Rangeクラスは範囲を示すクラスです。Genericsで作られており、GenericsはISortableインタフェースを実装している必要があります。
一応Charクラスなどでも実装できるようにGenericsで作っていますが普通はIntegerクラスしか使わないでしょう。
値の表現は

    1..2
    3..4
    1..5

などです。
実装されているメソッドはisMember(value:T):boolです。valueの値が範囲内か判定します。
注意してほしいのはRangeオブジェクトにメッセージを送るにはRangeオブジェクトを括弧でくくらないといけない点です。これはパーサー上しかたがないことで仕様としています。

    (1..5).isMember(3)    # --> true

などです。
というのも範囲の値にはメッセージパッシングも含むことができるので、パーサーでは区別できないためです。以下の場合が区別できません。


    1..object.hoge().isMember()

1..objectが範囲なのか1..object.hoge()が範囲なのか判断ができないためです。Rangeオブジェクトにメッセージパッシングする場合はカッコを付けてください。

このままだと大した使いみちのないオブジェクトですがメソッドの引数で範囲を受け取るメソッドでRangeオブエジェクトは使うことができます。

    "ABCDEGHI".subString(1..3)   # --> "BC"
    slist{1,2,3,4,5}.subList(2..4)  # --> slist{3,4}

などです。
一応標準ライブラリではRangeは最後の値は範囲に含めないようにしてます。Pythonなどでそのようになっているためです。
あと個人的にコードを書いた感じではそのほうが使いやすかったためです。
最後の値を範囲に含めると色々と面倒くさいことが多かったためです。Pythonに習っておきました。
Rangeクラスの詳細はclover2に含まれるRange.clclを見るとわかると思います。Rangeクラスを使ったStringやList,Bufferクラスのメソッドもそちらにまとめてあります。良かったらRange.clclを見てみてください。
Rangeクラスはシンプルに作っています。気が向いたら、ユーザー様の方で何かメソッドを追加してみてください。