$RCSID ='$Id: clscan.pl,v 1.16 2005/11/17 14:43:34 hironobu Exp hironobu $';
#
# (C) 1999-2004 Hironobu SUZUKI;  GNU General Public License Software.
# Hironobu Software Toy's & H2NP presents 
# 
# Name: Clscan --- Common Log Scan, Analyze for the common security logs
# Author: Hironobu SUZUKI <hironobu@h2np.net>
# License: GPL version 2 ( see http://www.gnu.org/licenses/gpl.txt)
# Email: clscan@h2np.net

# 
my ( $rev, $revday ) = ( $RCSID =~ m!.*,v (\S+) (\d+/\d+/\d+) .*! );
use Socket;
use FileHandle;
my %class_level;
#$class_level{alert}=1;	# default ALERT 
my %alert_class;
my %warn_class;
my %ignore_class;
my %hostname_array;
my $homedir=".";
my $config_file="$homedir/clscan.conf";
my $syslog_file="";
my $system_require="$homedir/default";
my ($host,$month,$day,$time,$protocol,$from_addr,$from_port,$to_addr,$to_port);
my $fromhost = "";
my $debug="YES";
$outputformat = "text";
$sitename = "name";
$banner="CLSCAN";
$liststyle=1;
$generatedtime=localtime(time());
$dndbfile="dncache";		# db file name, used dbctl.pl

my $filehandle;

require "dbctl.pl";
require "html-format.pl";
require "text-format.pl";


###
# get_option appear twice, but it is NOT BUG.
get_option(@ARGV);		# -> to know read config file 
set_config();			# -> read config file and set configure
get_option(@ARGV);		# -> set option again because argument is 
#                               # option is strong than config setup 
###

#
# load module "foo".pl
#

require $system_require.".pl";


require "alert.pl";		# load alert
require "warn.pl";		# load warn
require "unknown.pl";		# load unknown

#
#

if ( $syslog_file eq "") {
    $filehandle = STDIN;
}
else {
    open(SYSLOGFILE,"$syslog_file") || die "Can't open file: $syslog_file\n";
    $filehandle=SYSLOGFILE;
}

while(<$filehandle>) {
    chop;
    tr/[A-Z]/[a-z]/;
    ($host,$month,$day,$time,$protocol,$from_addr,$from_port,$to_addr,$to_port)= lex_from_line($_);
    if ($month ne "") {
	if ( $class_level{'alert'} and $alert_class{"$protocol"} ne "") {
	    # protocol is registed as alert class
	    $fromhost = gethostname($from_addr);
	    log_alert($host,"$alert_class{$protocol}($protocol)",$month,
				$day,$time,$protocol,$fromhost,$to_addr);
	}
	elsif ( $class_level{'warn'} and $warn_class{"$protocol"} ne "") {
	    # protocol is registed as warn class
	    $fromhost = gethostname($from_addr);
	    log_warn($host,"$warn_class{$protocol}($protocol)",$month,
				$day,$time,$protocol,$fromhost,$to_addr);
	}
	elsif ( $alert_class{"$protocol"} eq "" 
	    and $warn_class{"$protocol"} eq ""
	    and $ignore_class{"$protocol"} eq "" 
	    and $class_level{'unknown'} 
	       and $from_addr ne "" ) {
	    # unknown protocol means "not alert, warn and ignore".
	    $fromhost = gethostname($from_addr);
	    log_unknown($host,$protocol,$month,$day,$time,$protocol,$fromhost,$to_addr);
	}
    }
}
close($filehandle);

if ( $class_level{'alert'} ) {	# show alert 
    alert_analyze();
}
if ( $class_level{'warn'} ) {	# show warn
    warn_analyze();
}
if ( $class_level{'unknown'} ) { # show unknown
    unknown_analyze();
}


finish_process();

sub finish_process()
{
    html_close();
    close_text_file();
}

#
# Gethostname lookup cashed hostname first
# 
sub gethostname {

    my ($addr)=@_;
    my $hostname = "";

    if ( $sitename ne "name" ) { # $sitename is "ipaddr" or something
	# return address directly
	return $addr;
				    
    }

    $hostname = $hostname_array{"$addr"};
    if ( $hostname ne "" ) {
	return $hostname;
    }

#
# Hostname not found in hostname cashe list
#

    if ( $addr =~ /\d+\.\d+\.\d+\.\d+/ ) {
    ## check by gethostbyaddr 
	#
	# $hostname=gethostname(inet_aton($addr),AF_INET);
	#
	$hostname=cached_gethostname($addr); # new!
    }
    $hostname_array{"$addr"}=$hostname;
    return $hostname;
}

sub get_option {
    my @largs=@_;
    my $larg="";
    foreach $larg (@largs) {
	if ($larg =~/-help/ ) {
	    print_usage();
	    exit 1;
	}
	if ( $larg =~ /-logfile=/ ) {
	    ($syslog_file)=($larg =~/-logfile=(.+)/);
	    if ( $syslog_file eq "") {
		print "No syslog file: -logfile=SYSLOG_FILENAME\n";
		exit 1;
	    }
	}
	if ( $larg =~ /-htmlfile=/ ) {
	    ($html_file)=($larg =~/-htmlfile=(.+)/);
	    if ( $html_file eq "") {
		print "No html file name: -htmlfile=HTML_FILENAME\n";
		exit 1;
	    }
	    else {
		set_html_file_name($html_file);
	    }
	}
	if ( $larg =~ /-textfile=/ ) {
	    ($text_file)=($larg =~/-textfile=(.+)/);
	    if ( $text_file eq "") {
		print "No text file name: -textfile=TEXT_FILENAME\n";
		exit 1;
	    }
	    else {
		set_text_file_name($text_file);
	    }
	}
	if ( $larg =~ /-config=/ ) {
	    ($config_file)=($larg =~/-config=(.+)/);
	    if ( $config_file eq "") {
		print "No config file: -config=CONFIG_FILENAME\n";
		exit 1;
	    }
	}
	if ( $larg =~  /-outputformat=/) {
	    ($outputformat)=($larg =~/-outputformat=(\w+)/);
	    if ( $outputformat =~ /(text|html)/ ) {
	    }
	    else {
		$outputformat="text";
	    }
	}
	if ( $larg =~ /-sitename=/) {
	    ($sitename)=($larg =~/-sitename=(\w+)/);
	}
	if ( $larg =~  /-dndb=/) {
	    ($dndbfile)=($larg =~/-dndb=(.+)/);
	}
    }
}
sub set_config
{
    open(C,"$config_file") or die "Can't open: $config_file\nbye\n";
    while(<C>) {
	if ( /^alert\s/i )  {
	    ($class,$service,$protocol)=/^(\w+)\s+(\w+)\s+(\w.+)/;
	    $alert_class{"$protocol"}=$service;
	}
	if ( /^warn\w*\s/i )  {
	    ($class,$service,$protocol)=/^(\w+)\s+(\w+)\s+(\w.+)/;
	    $warn_class{"$protocol"}=$service;
	}
	if (/^ignore\s/i) {
	    ($class,$service,$protocol)=/^(\w+)\s+(\w+)\s+(\w.+)/;
	    $ignore_class{"$protocol"}=$service;
	}
	if ( /^system\s/i ) {
	    ($system_require)=/^\w+\s+(\w+)\s+/;
	    set_html_headertitle($system_require);
	}
	if ( /^classlevel\s/i) {
	    if (/alert/i) { $class_level{'alert'}=1};
	    if (/warn/i)  { $class_level{'warn'}=1};
	    if (/unknown/i) {$class_level{'unknown'}=1};
	}
	if ( /^outputformat\s/i) {
	    ($outputformat)=/^\w+\s+(\w+)\s+/;
	}
	if (/^banner\s/i) {
	    s/^banner\s+//i ;
	    $banner =  $_;
	}
	if (/^liststyle\s/i) {
	    ($liststyle)= /^\w+\s+(\d+)\s+/;
	}
	if ( /^sitename\s/i) {
	    ($sitename)=/^\w+\s+(\w+)\s+/;
	}
    }
    close(C);
}

sub  print_usage() {
    print "Usage: clscan [options]\n";
    print "--------------------------------------------------\n";
    print "  -logfile=INPUTFILE : Router or System log file.\n";
    print "  -htmlfile=OUTPUTFILE  : set output html file name\n";
    print "  -textfile=TEXTFILE : set output text file name\n";
    print "  -config=configfile : configuration file\n";
    print "  -outputformat=(text|html) : output format, text or HTML\n";
    print "  -sitename=(name|no)  : resolve site name or not.\n";

    print "--------------------------------------------------\n";
    print "Rev $rev [$revday]\n";
    print "Email: clscan\@h2np.net\n";
}

