$RCSID ='$Id: dncache.pl,v 1.2 2005/11/17 14:43:43 hironobu Exp hironobu $';
#
# (C) 1999-2004 Hironobu SUZUKI;  GNU General Public License Software.
# Hironobu Software Toy's & H2NP presents 
# 
# Name: dncacshe --- Domain Name Cache 
# Author: Hironobu SUZUKI   / hironobu @ h2np . net  /
# License: GPL version 2 ( see http://www.gnu.org/licenses/gpl.txt)
# Email: .. use -help option

###
## Used packages
###
use Socket;
use FileHandle;

### program debugging flag


require "dbctl.pl";


##
my ( $rev, $revday ) = ( $RCSID =~ m!.*,v (\S+) (\d+/\d+/\d+) .*! );
use FileHandle;
my $config_file="clscan.conf";
my $syslog_file="";
my $system_require="default";
my ($host,$month,$day,$time,$protocol,$from_addr,$from_port,$to_addr,$to_port);
$generatedtime=time();
$dndbfile="dncache";		# db file name
$verbose=-1;
$dbflush=-1;			# DB flush 
$dbdump=-1;			# DB dump 
$expire=-1;			# expire days
$iptest=-1;			# iptest 


# get_option appear twice, but it is NOT BUG.
get_option(@ARGV);		# -> to know read config file 
set_config();			# -> read config file and set configure
get_option(@ARGV);		# -> set option again because argument is 
#                               # option is strong than config setup 
###


## open dndb file
init_dncache();

if ( $dbdump > 0) {
    db_dump();
    finish_dncache();
    exit(0);
}

if ( $dbflush > 0 ) {	# "db flush" means 0 day expire
    db_flush();
    finish_dncache();
    exit(0);
}

if ( $expire > 0) {		#  more  than 0 day
    db_expire($expire);
    finish_dncache();
    exit(0);
}

if ( $syslog_file eq "") {
    $filehandle = STDIN;
}
else {
    open(SYSLOGFILE,"$syslog_file") || die "Can't open file: $syslog_file\n";
    $filehandle=SYSLOGFILE;
}

if ( $iptest == 1 ) { 
    iptest();
    exit 0;
}

#
# load module "foo".pl
#


require $system_require.".pl";

while(<$filehandle>) {
    chop;
    tr/[A-Z]/[a-z]/;
    ($host,$month,$day,$time,$protocol,$from_addr,$from_port,$to_addr,$to_port)= lex_from_line($_);
    if ($from_addr =~ /\d+\.\d+\.\d+\.\d+/) {
	$fromhostname = cached_gethostname($from_addr);
    }
}

## close dndb file
finish_dncache();

sub get_option {
    my @largs=@_;
    my $larg="";
    foreach $larg (@largs) {
	if ($larg =~/-help/ ) {
	    print_usage();
	    exit 1;
	}
	elsif ( $larg =~ /-logfile=/ ) {
	    ($syslog_file)=($larg =~/-logfile=(.+)/);
	    if ( $syslog_file eq "") {
		print "No syslog file: -logfile=SYSLOG_FILENAME\n";
		exit 1;
	    }
	}
	elsif ( $larg =~ /-config=/ ) {
	    ($config_file)=($larg =~/-config=(.+)/);
	    if ( $config_file eq "") {
		print "No config file: -config=CONFIG_FILENAME\n";
		exit 1;
	    }
	}
	elsif ( $larg =~  /-dndb=/) {
	    ($dndbfile)=($larg =~/-dndb=(.+)/);
	}
	elsif ( $larg =~  /-verbose/) {
	    $verbose=1;
	}
	elsif ( $larg =~  /-dbflush/) {
	    $dbflush=1;
	}
	elsif ( $larg =~  /-iptest/) {
	    $iptest=1;
	}
	elsif ( $larg =~ /-expire/ ) {
	    ($expire)=($larg =~/-expire=(\d+)/);
	    if ($expire < 1 ) {
		print "Option error: -expire\n";
		print_usage();
		exit 1;
	    }
	}
	elsif ( $larg =~ /-dbdump/ ) {
	    $dbdump=1;
	}
	elsif ( $larg =~ /-/ ) {	
	    print "Unknown option: $larg\n";
	    print_usage();
	    exit 1;
	}
    }
}
sub set_config
{
    open(C,"$config_file") or die "Can't open: $config_file\nbye\n";
    while(<C>) {
	if ( /^system\s/i ) {
	    ($system_require)=/^\w+\s+(\w+)\s+/;
	}
	if ( /^dndb\s/i) {
	    ($dndbfile)=/^\w+\s+([^\s]+)/;
	}
    }
    close(C);
}
sub iptest {
    $msg=open_dndb(); # opentest
    if ( $opened_db_flag == -1 ) {
	print "Open error:\n\t$msg\n";
	exit 1;
    }
    while(<STDIN>) {
	chop;
	if ( $_ =~ /^\d+\.\d+\.\d+\.\d+$/ ) {
	    $hostname=cached_gethostname($_);
	    if ( $hostname ne "" ) {
		print "$_ $hostname\n";
	    }
	    else {
		print "$_ unknown\n";
	    }
	}
	else {
	    print "Format error: $_\n";
	}
    }
    exit 0 ;			# bye!
}

sub  print_usage() {
    print "Usage: dncache [options]\n";
    print "-------------------------------------------------------\n";
    print " -config=configfile : configuration file\n";
    print " -dndb=dndbfile     : domain name database file\n";
    print "    Note: Do not include database suffix.\n";
    print " -dbflush           : clear db entry\n";
    print " -expire=n          : expire data entry before n days\n";
    print " -dbdump            : dump db only\n";
    print " -iptest            : ipaddress to db content test.\n";
    print "    Example: \$ echo 192.168.0.1 | dncache -iptest\n";
    print "-------------------------------------------------------\n";
    print "Rev $rev [$revday]\n";
    my $t=localtime($generatedtime);
    my ($year)=($t =~ /\s(\d\d\d\d)/);
    print "Email: clscan$year\@h2np.net\n";

}
