$RCSID ='$Id: statform.pl,v 1.8 2004/06/01 05:58:06 hironobu Exp hironobu $';
# (C) 1999-2004 Hironobu SUZUKI;  GNU General Public License Software.
# Name: Statistics format for CLSCAN output file
# Author: Hironobu SUZUKI <hironobu@h2np.net>
# License: GPL version 2 ( see http://www.gnu.org/licenses/gpl.txt)
# Email: clscan@h2np.net

use Socket;
my ( $rev, $revday ) = ( $RCSID =~ m!.*,v (\S+) (\d+/\d+/\d+) .*! );
my $exectime=localtime(time());
my $resolve_host = 0;	# resolved host addresses

sub  print_usage() {

    print "Usage: statform [-clscanfile=INPUTFILE] [-htmlfile=OUTPUTFILE]\n";
    print "\t[-resolve-host]\n";
    print "\t[-byport] [-byday] [-bysrc]\n";
    print "--------------------------------------------------\n";
    print "  -clscanfile=INPUTFILE : set input file name which must be clscan output html file.\n";
    print "  -htmlfile=OUTPUTFILE  : set output html file name\n";
    print "  -resolve-host : show list by resolved host addresses\n";
    print "  -byport : show list by port\n";
    print "  -byday  : show list by day\n";
    print "  -bysrc  : show list by source address\n";
    print "  default : all -by* options are on and all of lists will be shown\n";
    print "--------------------------------------------------\n";
    print "Rev  $rev [$revday]\n";
    print "Email: clscan\@h2np.net\n";
    exit 1;

}

my $input_file="";
my $inputfilehandle;
my $outfilehandle;
my $bysrc_flag="";
my $byport_flag="";
my $byday_flag="";
my @savelist;
my $index=0;
my %byport;
my %byday;
my %bysrc;
my %hostname_array;


get_option(@ARGV);
open_files();

start_html();
strip_html();

if ( $byport_flag eq "on" ) {
    count_by_port();
}
if ($byday_flag eq "on") {
    count_by_day();
}
if ($bysrc_flag eq "on") {
    count_by_src ();
}
close_html();

sub start_html {

    print $outfilehandle "<HTML><BODY bgcolor=#F0E0C0>\n";
    print $outfilehandle "<CENTER><H1> CLSCAN : Security Log Statistics </H1></CENTER>\n";
    printf $outfilehandle "<P align=right> Date: $exectime  </P>\n";

}

sub close_html {

    print $outfilehandle "<HR>\n";
    print $outfilehandle "this page was generated $exectime by  verion $rev [$revday]\n";
    print $outfilehandle "</BODY></HTML>\n";

}

sub strip_html {

    while(<$inputfilehandle>) {
	chop;
	$line=$_;
	if ($line =~ /TR bgcolor=/ ) {
	    if ($line =~ /"E0F0.."/ ) {
		$line =~ s/<TD>/,/g;
		$line =~ s/<\/TR>//g;
		$line =~ s/<TR bgcolor=.+>,//g;
		$line =~ s/\s+,/,/g;
		$line =~ s/,\s+/,/g;
		$line =~ s/^\s+//;
		$savelist[$index++]= $line;
		($day,$port,$dist,$src)=split(',',$line);
	    }
	}
    }

}

sub count_by_src  {

    my $i;
    my $total;
    my $key;
    my $from_host;

    print $outfilehandle "<H2>By Sender </H2>\n";
    print $outfilehandle "<TABLE border=1 bgcolor=#E0F0C0>\n";
    print $outfilehandle "<TR bgcolor=#E0C0FF><TH>Sender <TH>Times<TH>Rate<TH>";
    print $outfilehandle "<FONT color=#FFFFFF>";
    print $outfilehandle "0%---+----+----+----+--50%--+----+----+----+--100%";
    print $outfilehandle "</FONT></TR>\n";

    for ($i=0;$i < $index; $i++) {
	($day,$port,$dist,$src)=split(',',$savelist[$i]);
	$bysrc{$src} += 1;
    }

    foreach $key (keys %bysrc) {
	$total += $bysrc{$key};
    }

    foreach $key (sort sortbysrc keys %bysrc) {
	$p=( $bysrc{$key} / $total )*100;
	if ( $resolve_host ) {
	    $from_host = $hostname_array{"$key"};
	    if ( $from_host eq "" ) {
		$from_host = gethostname( $key );
	    }
	    printf  $outfilehandle
		"<TR><TD>%s<TD align=right>%s<TD align=right>%.2f%<TD>%s</TR>\n",$from_host,$bysrc{$key},$p,add_bar($p);
	} else {
	    printf  $outfilehandle
		"<TR><TD>%s<TD align=right>%s<TD align=right>%.2f%<TD>%s</TR>\n",$key, $bysrc{$key},$p,add_bar($p);
	}
    }

    print $outfilehandle "</TABLE>\n";

}

sub count_by_day  {

    my $i;
    my $key;
    my $mon;
    my $d;
    my $dkey;
    my $total;

    print $outfilehandle "<H2>By Date </H2>\n";
    print $outfilehandle "<TABLE border=1 bgcolor=#E0F0C0>\n";
    print $outfilehandle "<TR bgcolor=#E0C0FF><TH>Date <TH>Times<TH>Rate<TH>";
    print $outfilehandle "<FONT color=#FFFFFF>";
    print $outfilehandle "0%---+----+----+----+--50%--+----+----+----+--100%";
    print $outfilehandle "</FONT></TR>\n";

    for ($i=0;$i < $index; $i++) {
	($day,$port,$dist,$src)=split(',',$savelist[$i]);
	($mon,$d) = ($day =~ /(\w+)\s+(\w+)/);
	$dkey=$mon."_".$d;
	$byday{$dkey} += 1;
    }

    foreach $key (keys %byday) {
	$total += $byday{$key};
    }

    foreach $key (sort sortbyday keys %byday) {
	($mon,$d)=split('_',$key);
	$p = ( $byday{$key} / $total )*100;
	printf  $outfilehandle
	    "<TR><TD>%s  %s<TD align=right>%s<TD align=right>%.2f%<TD>%s</TR>\n",
	$mon,$d, $byday{$key},$p,add_bar($p);

    }

    print $outfilehandle "</TABLE>\n";

}

sub count_by_port  {

    my $i;
    my $key;
    my $total;
    my $p;

    print $outfilehandle "<H2>By Service </H2>\n";
    print $outfilehandle "<TABLE border=1  bgcolor=#E0F0C0>\n";
    print $outfilehandle "<TR bgcolor=#E0C0FF><TH>Service<TH>Times<TH>Rate<TH>";
    print $outfilehandle "<FONT color=#FFFFFF>";
    print $outfilehandle "0%---+----+----+----+--50%--+----+----+----+--100%";
    print $outfilehandle "</FONT></TR>\n";

    for ($i=0;$i < $index; $i++) {
	($day,$port,$dist,$src)=split(',',$savelist[$i]);
	$byport{$port} += 1;
    }

    foreach $key (keys %byport) {
	$total += $byport{$key};
    }

    foreach $key (sort sortbyport  keys %byport) {
	$p=($byport{$key} / $total )*100;
	printf  $outfilehandle
	    "<TR><TD>%s<TD align=right>%s<TD align=center>%.2f%<TD>%s</TR>\n",
	$key,$byport{$key},$p,add_bar($p);
    }

    print $outfilehandle "\n</TABLE>\n";

}

sub sortbyport {
    $byport{$b} <=> $byport{$a};
}
sub sortbyday {
    $byday{$b} <=> $byday{$a};
}
sub sortbysrc {
    $bysrc{$b} <=> $bysrc{$a};
}

sub add_bar {

    my ($max) = @_;
    my $i;
    my $retval="";

    for ($i=0;$i < $max; $i+=2) {
	$retval = $retval."*";
    }

    return $retval;

}

#
# Gethostname lookup cashed hostname first
# 

sub gethostname {

    my ( $addr ) = @_;
    my $hostname = "";

    #
    # Hostname not found in hostname cashe list
    #

    if ( $addr =~ /\d+\.\d+\.\d+\.\d+/ ) {
	$hostname = gethostbyaddr( inet_aton( $addr ), AF_INET );
	if ( $hostname eq "" ) {
	    $hostname = $addr;
	}
    }

    $hostname_array{"$addr"} = $hostname;

    return $hostname;

}

sub get_option {

    my @largs=@_;
    my $larg="";
    my $by_flag = 0;

    foreach $larg (@largs) {
	if ( $larg =~ /-clscanfile=/ ) {
	    ($input_file)=($larg =~/-clscanfile=(.+)/);
	    if ( $input_file eq "") {
		die "No clscan outputfile: -clscanfile=CLSCANOUTPUT.html\n";
	    }
	}
	if ( $larg =~ /-htmlfile=/ ) {
	    ($html_file)=($larg =~/-htmlfile=(.+)/);
	    if ( $html_file eq "") {
		die "No html file name: -htmlfile=HTML_FILENAME\n";
	    }
	}
        if ( $larg =~ /-resolve-host/ ) { # resolved host addresses
	    $resolve_host = 1;
        }
	if ( $larg =~ /-bysrc/ ) {
	    $bysrc_flag="on";
	    $by_flag = 1;
	}
	if ( $larg =~ /-byport/ ) {
	    $byport_flag="on";
	    $by_flag = 1;
	}
	if ( $larg =~ /-byday/ ) {
	    $byday_flag="on";
	    $by_flag = 1;
	}
	if ( $larg =~ /-help/ ) {
	    print_usage();
	}
    }

    unless ( $by_flag ) {
	$bysrc_flag = "on";
	$byport_flag = "on";
	$byday_flag = "on";
    }

}

sub open_files {

    if ( $input_file eq "") {
	$inputfilehandle = STDIN;
    } else {
	open(INFILE,"$input_file") || die "Can't open file: $input_file\n";
	$inputfilehandle=INFILE;
    }

    if ( $html_file eq "") {
	$outfilehandle = STDOUT;
    } else {
	open(OUTFILE,">$html_file") || die "Can't open file: $html_file\n";
	$outfilehandle=OUTFILE;
    }

}
1;

