#!/bin/sh -
#
# $Id: config.sh,v 1.5 2004/06/01 05:55:48 hironobu Exp hironobu $
# (C) 1999-2000 Hironobu SUZUKI <hironobu@h2np.net> 
#  GNU General Public License Software.
#

PACKAGEDIR=`pwd`
PERLCOM=`which perl`
PROGRAM='clscan statform dncache'

if [ ! -x $PERLCOM ]; then
    echo "$PERLCOM: Command not found."
    exit 1
fi

echo "Package directory is $PACKAGEDIR"
echo "Package bin is $PACKAGEDIR/bin"
echo "Package etc is $PACKAGEDIR/etc"
echo "Package lib is $PACKAGEDIR/lib"
echo "Package doc is $PACKAGEDIR/doc"
echo "Perl program is $PERLCOM"
echo -n 'Sure? [[n]/Y] '
read r

if [ x"$r" != xY ]; then
    echo 'bye!'
    exit 1
fi

for PRG in $PROGRAM; do
    d=`date`
    /bin/cat << EOF > $PACKAGEDIR/bin/$PRG
#!$PERLCOM
push @INC, "$PACKAGEDIR/lib";
## CONFIGED AT $d by $USER
EOF
    /bin/cat $PACKAGEDIR/bin/$PRG.pl >> $PACKAGEDIR/bin/$PRG
    /bin/chmod +x $PACKAGEDIR/bin/$PRG
    echo "install $PACKAGEDIR/bin/$PRG"
done

/bin/cat .package_version >> $PACKAGEDIR/install-log
echo " was installed by $USER at $d" >> $PACKAGEDIR/install-log
echo 'done.'
exit 0

