#-*-mode:perl-*-
#
# $Id: ba8000.pl,v 1.1 2003/04/21 00:49:07 hironobu Exp $
#
# Subroutine of CLSCAN.pl
sub lex_from_line{
    if (/\sdropped\s/) {
	my ($host,$month,$day,$time,
	    $protocol,$from_addr,$from_port,$to_addr,$to_port);

	if (/^.+,\s+/) { # mail or from web
	    ($month,$day,$time, #'Sun, 200X-XX-XX XX:XX:XX'
	     $dummy, # '-'
	     $protocol, $dummy, $dummy, # (TCP|UDP) (packet|connection) dropped
	     $dummy, # '-'
	     $from,
	     $dummy, # '-'
	     $to)
		= split(' ');
	    ($month, $day) = ($day =~ /\d{4}-(\d+)-(\d+)/);
	    $host = '---'
	}
	else { #syslog
	    ($month,$day,$time, #'Apr XX XX:XX:XX'
	     $host,
	     $dymmy,
	     $protocol, $dummy, $dummy, # (TCP|UDP) (packet|connection) dropped
	     $dummy, # '-'
	     $from,
	     $dummy, # '-'
	     $to)
		= split(' ');
	}

	my ($from_addr,$from_port) = ($from =~ /(\d+\.\d+\.\d+\.\d+),(\d+)/);
	my ($to_addr,$to_port) = ($to =~ /(\d+\.\d+\.\d+\.\d+),(\d+)/);

#	print STDERR "$month,$day,$time,$to_port/$protocol,$from_addr,$from_port,$to_addr,$to_port\n";
	return ($host,$month,$day,$time,
		"$to_port/$protocol",$from_addr,$from_port,$to_addr,$to_port);
    }
    else {
	return "";
    }
}
1;

