$RCSID ='$Id: dbctl.pl,v 1.2 2005/11/17 14:43:39 hironobu Exp hironobu $';
#
# (C) 1999-2004 Hironobu SUZUKI;  GNU General Public License Software.
# Hironobu Software Toy's & H2NP presents 
# 
# Name: dbctl --- Domain Name Cache Database Handling Library
# Author: Hironobu SUZUKI   / hironobu @ h2np . net  /
# License: GPL version 2 ( see http://www.gnu.org/licenses/gpl.txt)

###
## Used packages
###
use Socket;
use FileHandle;



### program debugging flag
my %debug=();
$debug{'DBENTRYNUM'}=-1;
$debug{'DBOUT'}=-1;
$debug{'DBIN'}=-1;
$debug{'EXPIRE'}=-1;
$debug{'UPDATED'}=-1;

$opened_db_flag=0;
%dndb=();

## open dndb file
sub init_dncache {
    if ( $opened_db_flag == 0 ) {
	open_dndb();
    }
    else {
	die "Can't init dncache\n";
    }
}
sub finish_dncache {
    if ( $opened_db_flag == 1 ) {
	open_dndb();
    }
}

sub open_dndb {
    if ( $opened_db_flag == 1 ) {
	return 0;
    }
    $opened_db_flag = -1;	# for error
    dbmopen(%dndb,$dndbfile,0666) || return "Can't open: $dndbfile\n";
    $opened_db_flag=1;		# success
    if ( $debug{'DBENTRYNUM'} > 0) {
	my $i=0;
	while ( ($k,$v) = each %dndb ) {
	    $i++;
	}
	print "hash size: $i entries\n";
    }
    return "";
}

sub close_dndb {
    if ( $opened_db_flag == 1 ) {
	dbmclose(%dndb);
    }
    $opened_db_flag = 0;
}

sub db_flush() {
    db_expire(0);
}

sub db_expire() {
    my $expired_entry=0;
    open(F,">$dndbfile.txt") || die "Can't open: $dndbfile.txt\n";

    my ($expire_day)=@_;
    $expire_time = $generatedtime - ($expire_day * 24 * 3600);
    while ( ($k,$v) = each %dndb ) {
	($entrytime)= ($v =~/,(\d+)/);
	if ( $entrytime > 0 && $entrytime <  $expire_time ) {
	    if ( $debug{'EXPIRE'} > 0 ) {
		print "expire: $dndb{$k}\n";
		$expired_entry++;
	    }
	}
	else {
	    print F "$k $v\n";
	}
    }
    close_dndb();
    close(F);
    if ( $expired_entry <  1 ) {	# No expired
	if ( $debug{'UPDATED'} > 0 ) {
	    print "No expired\n";
	}
	return 0;
    }
    system("mv $dndbfile.dir $dndbfile.old.dir");
    system("mv $dndbfile.pag $dndbfile.old.pag");

    open(F,"<$dndbfile.txt") || die "Can't open: $dndbfile.txt\n";
    open_dndb();
    while ( <F> ) {
	chop;
	($k,$v)= split ' ',$_;
	$dndb{$k}=$v;
    }
    close_dndb();
    close(F);
    unlink("$dndbfile.txt") || die "Can't remove $dndbfile.txt\n";
    # 
    return 1;
}

sub db_dump() {
    while ( ($k,$v) = each %dndb ) {
	print "$k $dndb{$k}\n";
    }
}

#
# Gethostname lookup cashed hostname first
# 
sub cached_gethostname {
    my ($addr)=@_;
    my $hostname = "";

    if ( $opened_db_flag == 0 ) { # try to open db
	open_dndb();
	if ($opened_db_flag == -1) {	#  open error db
	    # Is there something to recover from error?
	}
    }

    if ( $addr =~ /\d+\.\d+\.\d+\.\d+/ ) {
	#
	#  addr is collect ex) 192.168.0.1
    }
    else {
	die "Internal Error, address format: $addr\n";
    }

    if ( $opened_db_flag == 1 ) { # db has been opened
	$entry = $dndb{"$addr"};
	if ( $entry ne "" ) {
	    if ( $debug{'DBOUT'} > 0 ) {
		print "DBOUT: $entry\n";
	    }
	    ($hostname) = ($entry =~ /^(.*),/); 
	    if ( $hostname eq "" ) {
		die "Null hostname is returned ($addr)\n";
	    }
	    return $hostname;
	}
    }
#
# Hostname not found in hostname cashe list
#
    if ( $addr =~ /\d+\.\d+\.\d+\.\d+/ ) {
	$hostname=gethostbyaddr(inet_aton($addr),AF_INET);
	if ( $hostname eq "" ) {
	    $hostname = $addr;
	}
    }
    $entryformat="$hostname,$generatedtime";
    if ( $debug{'DBIN'}  > 0 ) {
	print "DBIN: $entryformat\n";
    }

    $dndb{"$addr"}=$entryformat;
    return $hostname;
}
1;
