#-*-mode:perl-*-
#
# $Id: rt80i.pl,v 1.4 2001/01/31 04:19:52 hironobu Exp $
#
# Subroutine of CLSCAN.pl
my %name_port_map;
$name_port_map{tcpmux}=1;
$name_port_map{rje}=5;
$name_port_map{echo}=7;
$name_port_map{discard}=9;
$name_port_map{systat}=11;
$name_port_map{daytime}=13;
$name_port_map{chargen}=19;
$name_port_map{ftp}=20;
$name_port_map{ftp}=21;
$name_port_map{telnet}=23;
$name_port_map{smtp}=25;
$name_port_map{time}=37;
$name_port_map{nameserver}=42;
$name_port_map{whois}=43;
$name_port_map{auditd}=48;
$name_port_map{domain}=53;
$name_port_map{tacacs_ds}=65;
$name_port_map{dhcps}=67;
$name_port_map{dhcpc}=68;
$name_port_map{tftp}=69;
$name_port_map{gopher}=70;
$name_port_map{finger}=79;
$name_port_map{www}=80;
$name_port_map{kerberos}=88;
$name_port_map{pop2}=109;
$name_port_map{pop3}=110;
$name_port_map{sunrpc}=111;
$name_port_map{ident}=113;
$name_port_map{nntp}=119;
$name_port_map{ntp}=123;
$name_port_map{netbios_ns}=137;
$name_port_map{netbios_dgm}=138;
$name_port_map{netbios_ssn}=139;
$name_port_map{imap2}=143;
$name_port_map{snmp}=161;
$name_port_map{snmptrap}=162;
$name_port_map{bgp}=179;
$name_port_map{irc}=194;
$name_port_map{at_rtmp}=201;
$name_port_map{at_nbp}=202;
$name_port_map{at_3}=203;
$name_port_map{at_echo}=204;
$name_port_map{at_5}=205;
$name_port_map{at_zis}=206;
$name_port_map{at_7}=207;
$name_port_map{at_8}=208;
$name_port_map{imap3}=220;
$name_port_map{ldap}=389;
$name_port_map{netware_ip}=396;
$name_port_map{timbuktu}=407;
$name_port_map{mobileip_agent}=434;
$name_port_map{mobilip_mn}=435;
$name_port_map{https}=443;
$name_port_map{biff}=512;
$name_port_map{login}=513;
$name_port_map{syslog}=514;
$name_port_map{printer}=515;
$name_port_map{talk}=517;
$name_port_map{route}=520;
$name_port_map{uucp}=540;
$name_port_map{doom}=666;

sub lex_from_line{
    my($line) = @_;
    if (/\srejected\s/) {
	my($m,$d,$t,$h,$dmy,$dmy,$dmy,$dmy,$dmy,$p,$frominfo,$dmy,$toinfo) = split('\s+',$line);
	my($fa,$fp) = split(':',$frominfo);
	my($ta,$tp) = split(':',$toinfo);
	if ($name_port_map{$fp}) {
# $fp is NOT port number
	    my $port = $name_port_map{$fp};
	    $fp = $port;
	}
	if ($name_port_map{$tp}) { 
# $tp is NOT port number 
	    my $port = $name_port_map{$tp};
	    $tp = $port;
	}
#	print "$h, $m, $d, $t, $tp/$p, $fa, $fp, $ta, $tp\n";
	return ($h, $m, $d, $t, "$tp/$p", $fa, $fp, $ta, $tp);
    }
    else {
	return "";
    }
}
1;
