﻿SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Function structure for CMSF_FUNC_SAMPLE
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_SAMPLE`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_SAMPLE`(p_sample1 varchar(255) , p_sample2 int(18)) RETURNS text CHARSET utf8
BEGIN
/**
 * 処理内容を記載してください。
 *
 * @package     CMSF
 * @category    CMSF_FUNC_SAMPLE
 * @param       varchar(255) p_sample1 サンプルデータ1
 * @param       int(18)      p_sample2 サンプルデータ1
 * @return      text         サンプル処理済みデータ
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/13 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.2 2009/07/24 実行時間取得ロジック追加、クエリログ出力時の実行件数ログ出力ロジック追加、ログSQL文の最大長を2000文字から65555文字に変更 Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_PUT_LOG
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    text            default '';             /* Query Log */
 declare w_start_time                   DATETIME        default NULL;           /* 実行開始時間 */
 declare w_start_unixtime               int(18)         default NULL;           /* 実行開始時間 */
 declare w_end_time                     DATETIME        default NULL;           /* 実行終了時間 */
 declare w_end_unixtime                 int(18)         default NULL;           /* 実行終了時間 */
 declare w_exection_time                int(18)         default NULL;           /* 実行時間 */


 /* ユーザー定義変数 */
 declare w_sample1                      varchar(255)    default NULL;           /*  文字列 */
 declare w_sample2                      int(18)         default NULL;           /*  数字 */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

  SELECT文のサンプル SELECT文
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_select
                                     , '2.1.1 処理名称 ' , w_log_query , CONCAT( '検索結果:' , FOUND_ROWS() , '件') , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'SAMPLE_PROJECT';                       /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'SAMPLE_APPLICATION';                   /*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_SAMPLE';                        /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.2';                                /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_sample1          = p_sample1;    /*  サンプルコメント */
 SET w_sample2          = p_sample2;    /*  サンプルコメント */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_start_time     = SYSDATE();
        SET w_start_unixtime = UNIX_TIMESTAMP(w_start_time);

        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_sample1 , ',' ,CAST( p_sample2 AS CHAR) ) , s_empty_string , CONCAT( '開始時間:' , w_start_time ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

/* 2.1.1 サンプル処理 */
 SET w_result          = CONCAT( p_sample1 , p_sample2 );    /*  文字列連結処理 */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN

 /* ログ出力サンプル SQLログの場合 */
 SET w_log_query = CONCAT(
 "SQL"
 );
 /* SELECT文の場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_select
                                     , '2.1.1 処理名称 ' , w_log_query , CONCAT( '検索結果:' , FOUND_ROWS() , '件') , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' );
 /* INSERT文の場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_insert
                                     , '2.1.1 処理名称 ' , w_log_query , CONCAT( '挿入件数:' , ROW_COUNT() , '件') , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' );
 /* UPDATE文の場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_update
                                     , '2.1.1 処理名称 ' , w_log_query , CONCAT( '更新件数:' , ROW_COUNT() , '件') , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' );
 /* DELETE文の場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_delete
                                     , '2.1.1 処理名称 ' , w_log_query , CONCAT( '削除件数:' , ROW_COUNT() , '件') ,'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' );


 /* ログ出力サンプル テキストログの場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '2.1.1 処理名称 ' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
 /* ログ出力サンプル エラーログの場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_error
                                     , '2.1.1 処理名称 ' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
 /* ログ出力サンプル 一時的にログを出力したい場合 */
 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_tmp
                                     , '2.1.1 処理名称 ' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );


 END IF;



 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN

        SET w_end_time      = SYSDATE();
        SET w_end_unixtime  = UNIX_TIMESTAMP(w_end_time);
        SET w_exection_time = w_end_time - w_start_time;

        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , CONCAT( '開始時間:' , w_start_time ) , CONCAT( '終了時間:' , w_end_time ) , CONCAT( '実行時間:' , w_exection_time , '秒') , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Records 
-- ----------------------------
