/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;

public class CSVWrapper
implements FileWrapperCompatible {
    private String fileName;
    private LinkedList<LinkedList<String>> sheet;

    public CSVWrapper() {
        this.fileName = "";
        this.sheet = new LinkedList();
    }

    public CSVWrapper(String string) {
        this.fileName = string;
        this.sheet = new LinkedList();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                LinkedList<String> linkedList = new LinkedList<String>();
                for (String string3 : string2.split(",")) {
                    linkedList.add(string3);
                }
                this.sheet.add(linkedList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRow() {
        this.sheet.add(new LinkedList());
    }

    public LinkedList<String> getRow(int n) {
        return this.sheet.get(n);
    }

    public void addValue(int n, String string) {
        this.getRow(n).add(string);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, SAXException {
        for (LinkedList linkedList : this.sheet) {
            for (String string : linkedList) {
                outputStream.write((string + ",").getBytes());
            }
            outputStream.write(System.getProperty("line.separator").getBytes());
        }
        outputStream.close();
    }

    @Override
    public void write(Writer writer) throws IOException, SAXException {
        for (LinkedList linkedList : this.sheet) {
            for (String string : linkedList) {
                writer.write(string + ",");
            }
            writer.write(System.getProperty("line.separator"));
        }
        writer.close();
    }

    @Override
    public void writeGZippedFile(File file) throws IOException, SAXException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    @Override
    public void writefile(File file) throws IOException, SAXException {
        this.write(new FileWriter(file));
    }

    public static void main(String[] stringArray) {
        try {
            CSVWrapper cSVWrapper = new CSVWrapper("a.csv");
            cSVWrapper.write(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

