/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mp3;

import com.sun.media.codec.audio.mp3.JS_MP3DecoderStream;
import java.lang.reflect.Method;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public class JS_MP3ConversionProvider
extends FormatConversionProvider {
    public static boolean DEBUG = false;
    static final AudioFormat.Encoding MPEG1L1 = JS_MP3ConversionProvider.getEncoding("MPEG1L1");
    static final AudioFormat.Encoding MPEG1L2 = JS_MP3ConversionProvider.getEncoding("MPEG1L2");
    static final AudioFormat.Encoding MPEG1L3 = JS_MP3ConversionProvider.getEncoding("MPEG1L3");
    static final AudioFormat.Encoding MPEG2L1 = JS_MP3ConversionProvider.getEncoding("MPEG2L1");
    static final AudioFormat.Encoding MPEG2L2 = JS_MP3ConversionProvider.getEncoding("MPEG2L2");
    static final AudioFormat.Encoding MPEG2L3 = JS_MP3ConversionProvider.getEncoding("MPEG2L3");
    static final AudioFormat.Encoding MP3 = JS_MP3ConversionProvider.getEncoding("MP3");
    static final AudioFormat.Encoding SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    private static final AudioFormat.Encoding[] sourceEncodings = new AudioFormat.Encoding[]{MPEG1L1, MPEG1L2, MPEG1L3, MP3, MPEG2L1, MPEG2L2, MPEG2L3};
    private static final AudioFormat.Encoding[] targetEncodings = new AudioFormat.Encoding[]{SIGNED};
    private static final int MAX_CHANNELS = 2;
    private static final int[] SAMPLE_SIZE_IN_BITS = new int[]{16};
    private static final float[] SAMPLE_RATES = new float[]{16000.0f, 22050.0f, 24000.0f, 32000.0f, 44100.0f, 48000.0f};
    private static AudioFormat[] targetFormats = null;
    private static final String TENCODINGS_CLASS = "org.tritonus.share.sampled.Encodings";
    private static final String TGETENCODING_METHOD = "getEncoding";
    private static Class tEncodings;
    private static Method tGetEncoding;
    private static boolean triedTritonus;
    static /* synthetic */ Class class$java$lang$String;

    public AudioFormat.Encoding[] getSourceEncodings() {
        return sourceEncodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return targetEncodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (this.getTargetFormats(sourceFormat, true) == null) {
            return new AudioFormat.Encoding[0];
        }
        return this.getTargetEncodings();
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (!JS_MP3ConversionProvider.encodingEquals(targetEncoding, SIGNED)) {
            return new AudioFormat[0];
        }
        return this.getTargetFormats(sourceFormat, false);
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        AudioFormat targetFormat = new AudioFormat(targetEncoding, -1.0f, -1, -1, -1, -1.0f, true);
        return this.getAudioInputStream(targetFormat, sourceStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (sourceFormat.getSampleRate() > 0.0f && sourceFormat.getChannels() > 0) {
            AudioFormat[] targetFormats = this.getTargetFormats(sourceFormat, false);
            for (int i2 = 0; i2 < targetFormats.length; ++i2) {
                if (!JS_MP3ConversionProvider.audioFormatMatches(targetFormat, targetFormats[i2])) continue;
                return new JS_MP3DecoderStream(sourceStream, targetFormats[i2], -1L);
            }
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    private AudioFormat[] getTargetFormats(AudioFormat sourceFormat, boolean testOnly) {
        int bits;
        boolean allBits;
        int channels;
        boolean allChannels;
        int count = 0;
        for (int e2 = 0; e2 < sourceEncodings.length; ++e2) {
            count += JS_MP3ConversionProvider.encodingEquals(sourceFormat.getEncoding(), sourceEncodings[e2]) ? 1 : 0;
        }
        float sampleRate = sourceFormat.getSampleRate();
        boolean allSampleRates = JS_MP3ConversionProvider.floatEquals(sampleRate, -1.0f);
        if (count > 0) {
            if (allSampleRates) {
                count *= SAMPLE_RATES.length;
            } else {
                boolean srMatches = false;
                for (int sr = 0; sr < SAMPLE_RATES.length; ++sr) {
                    if (!JS_MP3ConversionProvider.floatEquals(SAMPLE_RATES[sr], sampleRate)) continue;
                    srMatches = true;
                    break;
                }
                if (!srMatches) {
                    count = 0;
                }
            }
        }
        boolean bl = allChannels = (channels = sourceFormat.getChannels()) == -1;
        if (count > 0) {
            if (allChannels) {
                count *= 2;
            } else if (channels < 1 || channels > 2) {
                count = 0;
            }
        }
        boolean bl2 = allBits = (bits = sourceFormat.getSampleSizeInBits()) == -1;
        if (count > 0) {
            if (allBits) {
                count *= SAMPLE_SIZE_IN_BITS.length;
            } else {
                boolean bitsSupported = false;
                for (int b2 = 0; b2 < SAMPLE_SIZE_IN_BITS.length; ++b2) {
                    if (bits != SAMPLE_SIZE_IN_BITS[b2]) continue;
                    bitsSupported = true;
                    break;
                }
                if (!bitsSupported) {
                    count = 0;
                }
            }
        }
        if (testOnly) {
            if (count == 0) {
                return null;
            }
            return new AudioFormat[0];
        }
        AudioFormat[] ret = new AudioFormat[count *= 2];
        if (count == 0) {
            return ret;
        }
        if (!(count != 2 || allSampleRates || allChannels || allBits)) {
            ret[0] = new AudioFormat(sampleRate, bits, channels, bits > 8, false);
            ret[1] = new AudioFormat(sampleRate, bits, channels, bits > 8, true);
            return ret;
        }
        int index = 0;
        for (int f2 = 0; f2 < targetFormats.length; ++f2) {
            AudioFormat format = targetFormats[f2];
            if (!allSampleRates && !JS_MP3ConversionProvider.floatEquals(sampleRate, format.getSampleRate()) || !allChannels && channels != format.getChannels() || !allBits && bits != format.getSampleSizeInBits()) continue;
            ret[index++] = format;
        }
        if (DEBUG && index != count) {
            System.out.println("JS_MP3ConversionProvider: inconsistency ERROR: did not fill all audio formats!");
        }
        return ret;
    }

    private static boolean encodingEquals(AudioFormat.Encoding enc1, AudioFormat.Encoding enc2) {
        return enc1 == enc2 || enc1 != null && enc2 != null && enc1.toString().equals(enc2.toString());
    }

    private static boolean floatEquals(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-9f;
    }

    private static boolean audioFormatMatches(AudioFormat f1, AudioFormat f2) {
        return !(!JS_MP3ConversionProvider.encodingEquals(f1.getEncoding(), f2.getEncoding()) || !JS_MP3ConversionProvider.floatEquals(f1.getSampleRate(), f2.getSampleRate()) && !JS_MP3ConversionProvider.floatEquals(f1.getSampleRate(), -1.0f) && !JS_MP3ConversionProvider.floatEquals(f2.getSampleRate(), -1.0f) || !JS_MP3ConversionProvider.floatEquals(f1.getFrameRate(), f2.getFrameRate()) && !JS_MP3ConversionProvider.floatEquals(f1.getFrameRate(), -1.0f) && !JS_MP3ConversionProvider.floatEquals(f2.getFrameRate(), -1.0f) || f1.getChannels() != f2.getChannels() && f1.getChannels() != -1 && f2.getChannels() != -1 || f1.getSampleSizeInBits() != f2.getSampleSizeInBits() && f1.getSampleSizeInBits() != -1 && f2.getSampleSizeInBits() != -1 || f1.getFrameSize() != f2.getFrameSize() && f1.getFrameSize() != -1 && f2.getFrameSize() != -1 || f1.getChannels() > 8 && f2.getChannels() > 8 && f1.isBigEndian() != f2.isBigEndian());
    }

    private static AudioFormat.Encoding getEncoding(String name) {
        AudioFormat.Encoding ret = null;
        if (!triedTritonus || tGetEncoding != null) {
            try {
                boolean firstTime;
                boolean bl = firstTime = !triedTritonus;
                if (!triedTritonus) {
                    triedTritonus = true;
                    tEncodings = Class.forName(TENCODINGS_CLASS);
                    tGetEncoding = tEncodings.getMethod(TGETENCODING_METHOD, class$java$lang$String == null ? (class$java$lang$String = JS_MP3ConversionProvider.class$("java.lang.String")) : class$java$lang$String);
                }
                Object[] args = new Object[]{name};
                ret = (AudioFormat.Encoding)tGetEncoding.invoke(null, args);
                if (DEBUG && firstTime) {
                    System.out.println("JS_MP3ConversionProvider: Using Tritonus' Encodings class");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = new AFE(name);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (DEBUG) {
            System.out.println("JS_MP3ConversionProvider: DEBUG enabled");
        }
        if (targetFormats == null) {
            targetFormats = new AudioFormat[SAMPLE_RATES.length * SAMPLE_SIZE_IN_BITS.length * 2 * 2];
            int index = 0;
            for (int sr = 0; sr < SAMPLE_RATES.length; ++sr) {
                for (int b2 = 0; b2 < SAMPLE_SIZE_IN_BITS.length; ++b2) {
                    for (int c2 = 0; c2 < 2; ++c2) {
                        int bits = SAMPLE_SIZE_IN_BITS[b2];
                        JS_MP3ConversionProvider.targetFormats[index++] = new AudioFormat(SAMPLE_RATES[sr], bits, c2 + 1, bits > 8, false);
                        JS_MP3ConversionProvider.targetFormats[index++] = new AudioFormat(SAMPLE_RATES[sr], bits, c2 + 1, bits > 8, true);
                    }
                }
            }
        }
        tEncodings = null;
        tGetEncoding = null;
        triedTritonus = false;
    }

    private static class AFE
    extends AudioFormat.Encoding {
        public AFE(String name) {
            super(name);
        }
    }
}

