/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.Controller;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AddBatchGUI
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private Controller controller;
    JButton saveBatch;
    JButton cancel;
    private JLabel nameLabel;
    private JTextArea nameArea;
    private Batch batch;

    public AddBatchGUI(Controller controller, Batch batch) {
        this.controller = controller;
        this.batch = batch;
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        this.nameLabel = new JLabel("Batch Name");
        this.nameLabel.setHorizontalAlignment(4);
        this.nameArea = new JTextArea("", 1, 20);
        this.nameArea.setColumns(15);
        this.saveBatch = new JButton("Save");
        this.saveBatch.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.setLayout(new GridLayout(2, 2, 6, 11));
        this.add(this.nameLabel);
        this.add(this.nameArea);
        this.add(this.saveBatch);
        this.add(this.cancel);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.saveBatch)) {
            this.save();
        } else if (actionEvent.getSource().equals(this.cancel)) {
            this.setVisible(false);
        }
    }

    protected void save() {
        int n = 0;
        int n2 = -1;
        if (this.nameArea.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Batch names cannot be empty", "ERROR", 0);
        } else {
            this.batch.setName(this.nameArea.getText());
            for (Batch batch : this.controller.batches) {
                if (batch.getName().equals(this.nameArea.getText())) {
                    n2 = n;
                }
                ++n;
            }
            if (n2 != -1) {
                int n3 = JOptionPane.showConfirmDialog(this, "This will overwrite an existing batch.  Continue Anyways?", "Confirm Overwrite", 0);
                if (n3 == 0) {
                    System.out.println(n2);
                    this.controller.batches.remove(n2);
                    this.controller.removeBatch.remove(n2);
                    this.controller.viewBatch.remove(n2);
                    this.add(this.batch);
                }
            } else {
                this.add(this.batch);
            }
            this.setVisible(false);
        }
    }

    private void add(Batch batch) {
        this.controller.batches.add(batch);
        if (!this.controller.removeBatch.isEnabled()) {
            this.controller.removeBatch.setEnabled(true);
        }
        JMenuItem jMenuItem = new JMenuItem(batch.getName());
        jMenuItem.addActionListener(this.controller.removeBatchAction);
        this.controller.removeBatch.add(jMenuItem);
        if (!this.controller.viewBatch.isEnabled()) {
            this.controller.viewBatch.setEnabled(true);
        }
        JMenuItem jMenuItem2 = new JMenuItem(batch.getName());
        jMenuItem2.addActionListener(this.controller.viewBatchAction);
        this.controller.viewBatch.add(jMenuItem2);
    }
}

