/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class AggregatorContainer {
    Vector<Aggregator> aggregatorTemplate = new Vector();
    Vector<Aggregator> aggregatorList = new Vector();
    Vector<FeatureExtractor> featureList = new Vector();
    Vector<Integer> featureIndecis2FeatureListMapping = new Vector();

    public void add(Aggregator[] aggregatorArray) throws Exception {
        for (int i = 0; i < aggregatorArray.length; ++i) {
            this.aggregatorTemplate.add(aggregatorArray[i]);
        }
        if (this.featureList.size() > 0) {
            this.buildAggregatorList();
        }
    }

    public void add(FeatureExtractor[] featureExtractorArray) throws Exception {
        boolean[] blArray = new boolean[featureExtractorArray.length];
        Arrays.fill(blArray, true);
        this.add(featureExtractorArray, blArray);
    }

    public void add(FeatureExtractor[] featureExtractorArray, boolean[] blArray) throws Exception {
        this.featureList.clear();
        for (int i = 0; i < featureExtractorArray.length; ++i) {
            if (!blArray[i]) continue;
            this.featureList.add(featureExtractorArray[i]);
            this.featureIndecis2FeatureListMapping.add(i);
        }
        if (this.aggregatorTemplate.size() > 0) {
            this.buildAggregatorList();
        }
    }

    public FeatureDefinition[] getFeatureDefinitions() {
        FeatureDefinition[] featureDefinitionArray = new FeatureDefinition[this.aggregatorList.size()];
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            featureDefinitionArray[i] = this.aggregatorList.get(i).getFeatureDefinition();
        }
        return featureDefinitionArray;
    }

    public void aggregate(double[][][] dArray) throws Exception {
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            this.aggregatorList.get(i).aggregate(dArray);
        }
    }

    public void outputACEFeatureKeyEntries(DataOutputStream dataOutputStream) throws Exception {
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            this.aggregatorList.get(i).outputACEFeatureKeyEntries(dataOutputStream);
        }
    }

    public void outputACEValueEntries(DataOutputStream dataOutputStream) throws Exception {
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            this.aggregatorList.get(i).outputACEValueEntries(dataOutputStream);
        }
    }

    public void outputARFFHeaderEntries(DataOutputStream dataOutputStream) throws Exception {
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            this.aggregatorList.get(i).outputARFFHeaderEntries(dataOutputStream);
        }
        dataOutputStream.writeBytes("@DATA" + System.getProperty("line.separator"));
    }

    public void outputARFFValueEntries(DataOutputStream dataOutputStream) throws Exception {
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            this.aggregatorList.get(i).outputARFFValueEntries(dataOutputStream);
            if (i >= this.aggregatorList.size() - 1) continue;
            dataOutputStream.writeBytes(",");
        }
        dataOutputStream.writeBytes(Aggregator.LINE_SEP);
    }

    void buildAggregatorList() throws Exception {
        this.aggregatorList.clear();
        for (int i = 0; i < this.aggregatorTemplate.size(); ++i) {
            Object object;
            int n;
            String[] stringArray = this.aggregatorTemplate.get(i).getFeaturesToApply();
            if (stringArray == null) {
                for (n = 0; n < this.featureList.size(); ++n) {
                    object = (Aggregator)this.aggregatorTemplate.get(i).clone();
                    ((Aggregator)object).setSource(this.featureList.get(n));
                    ((Aggregator)object).init(new int[]{this.featureIndecis2FeatureListMapping.get(n)});
                    this.aggregatorList.add((Aggregator)object);
                }
                continue;
            }
            n = 0;
            object = new int[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                n = 0;
                for (int k = 0; k < this.featureList.size(); ++k) {
                    if (!this.featureList.get((int)k).getFeatureDefinition().name.equals(stringArray[j])) continue;
                    n = 1;
                    object[j] = this.featureIndecis2FeatureListMapping.get(k);
                    break;
                }
                if (n == 0) break;
            }
            if (n == 0) continue;
            this.aggregatorTemplate.get(i).init((int[])object);
            this.aggregatorList.add(this.aggregatorTemplate.get(i));
        }
    }

    public double[][] getResults() {
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        for (int i = 0; i < this.aggregatorList.size(); ++i) {
            linkedList.add(this.aggregatorList.get(i).getResults());
        }
        return (double[][])linkedList.toArray((T[])new double[0][]);
    }
}

