/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class Mean
extends Aggregator {
    int feature;

    public Mean() {
        this.metadata = new AggregatorDefinition("Mean", "This is the overall average over all windows.", true, null);
    }

    public String[] getFeaturesToApply() {
        return null;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public void init(int[] nArray) throws Exception {
        this.feature = nArray[0];
    }

    public Object clone() {
        return new Mean();
    }

    public void setSource(FeatureExtractor featureExtractor) {
        FeatureDefinition featureDefinition = featureExtractor.getFeatureDefinition();
        this.definition = new FeatureDefinition(featureDefinition.name + " Overall Average", featureDefinition.description + System.getProperty("line.separator") + "This is the overall average over all windows.", featureDefinition.is_sequential, featureDefinition.dimensions);
    }

    public void aggregate(double[][][] dArray) {
        if (dArray == null || dArray.length == 0) {
            this.result = new double[1];
            this.result[0] = Double.NaN;
            this.definition.dimensions = 1;
        } else {
            int n;
            int n2 = -1;
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n][this.feature] == null || dArray[n][this.feature].length <= n2) continue;
                n2 = dArray[n][this.feature].length;
            }
            if (n2 <= 0) {
                this.result = new double[]{0.0};
                this.definition.dimensions = 1;
            } else {
                this.result = new double[n2];
                this.definition.dimensions = n2;
                for (n = 0; n < n2; ++n) {
                    int n3 = 0;
                    double d = 0.0;
                    for (int i = 0; i < dArray.length; ++i) {
                        if (dArray[i][this.feature] == null || dArray[i][this.feature].length <= n) continue;
                        d += dArray[i][this.feature][n];
                        ++n3;
                    }
                    this.result[n] = n3 == 0 ? 0.0 : d / (double)n3;
                }
            }
        }
    }
}

