/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;

public class BeatHistogram
extends FeatureExtractor {
    private int number_windows = 256;

    public BeatHistogram() {
        int n;
        String string = "Beat Histogram";
        String string2 = "A histogram showing the relative strength of different rhythmic periodicities (tempi) in a signal. Found by calculating the auto-correlation of the RMS.";
        boolean bl = true;
        int n2 = 0;
        this.definition = new FeatureDefinition(string, string2, bl, n2);
        this.dependencies = new String[this.number_windows];
        for (n = 0; n < this.dependencies.length; ++n) {
            this.dependencies[n] = "Root Mean Square";
        }
        this.offsets = new int[this.number_windows];
        for (n = 0; n < this.offsets.length; ++n) {
            this.offsets[n] = 0 - n;
        }
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i][0];
        }
        double d2 = d / (double)dArray3.length;
        int n = (int)(0.286 * d2);
        int n2 = (int)(3.0 * d2);
        double[] dArray4 = DSPMethods.getAutoCorrelation(dArray3, n, n2);
        return dArray4;
    }

    public void setWindowLength(int n) throws Exception {
        if (n < 2) {
            throw new Exception("BeatHistogram window length must be greater than 1");
        }
        this.number_windows = n;
        this.dependencies = new String[this.number_windows];
        this.offsets = new int[this.number_windows];
        for (int i = 0; i < this.number_windows; ++i) {
            this.dependencies[i] = "Root Mean Square";
            this.offsets[i] = 0 - i;
        }
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.number_windows);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:setElement");
        }
        try {
            int n2 = Integer.parseInt(string);
            this.setWindowLength(n2);
        }
        catch (Exception exception) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    public Object clone() {
        BeatHistogram beatHistogram = new BeatHistogram();
        beatHistogram.number_windows = this.number_windows;
        return beatHistogram;
    }
}

