/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;

public class BeatHistogramLabels
extends FeatureExtractor {
    private int binNumber = 256;

    public BeatHistogramLabels() {
        String string = "Beat Histogram Bin Labels";
        String string2 = "The bin label, in beats per minute, of each beat histogram bin. Not useful as a feature in itself, but useful for calculating other features from the beat histogram.";
        boolean bl = true;
        int n = 0;
        this.definition = new FeatureDefinition(string, string2, bl, n);
        this.dependencies = new String[1];
        this.dependencies[0] = "Beat Histogram";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        double[] dArray3 = dArray2[0];
        if (dArray3 != null) {
            double d2 = d / (double)this.binNumber;
            int n = (int)(0.286 * d2);
            int n2 = (int)(3.0 * d2);
            double[] dArray4 = DSPMethods.getAutoCorrelationLabels(d2, n, n2);
            int n3 = 0;
            while (n3 < dArray4.length) {
                int n4 = n3++;
                dArray4[n4] = dArray4[n4] * 60.0;
            }
            return dArray4;
        }
        return null;
    }

    public void setBinNumber(int n) throws Exception {
        if (n < 2) {
            throw new Exception("There must be at least 2 bins in Beat Histogram Labels");
        }
        this.binNumber = n;
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to BeatHistogramLabels:getElement");
        }
        return Integer.toString(this.binNumber);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to BeatHistogramLabels:setElement");
        }
        try {
            int n2 = Integer.parseInt(string);
            this.setBinNumber(n2);
        }
        catch (Exception exception) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    public Object clone() {
        return new BeatHistogramLabels();
    }
}

