/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class LPC
extends FeatureExtractor {
    double lambda = 0.0;
    int numDimensions = 10;

    public LPC() {
        String string = "LPC";
        String string2 = "Linear Prediction Coeffecients calculated using autocorrelation and Levinson-Durbin recursion.";
        String[] stringArray = new String[]{"lambda for frequency warping", "number of coeffecients to calculate"};
        this.definition = new FeatureDefinition(string, string2, true, 10, stringArray);
        this.dependencies = null;
        this.offsets = null;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        int n;
        int n2;
        double[] dArray3 = new double[this.numDimensions + 1];
        double[] dArray4 = new double[this.numDimensions];
        double[] dArray5 = new double[this.numDimensions];
        double[] dArray6 = new double[dArray.length];
        double[] dArray7 = new double[dArray.length];
        dArray3[0] = 0.0;
        dArray7[0] = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray7[0] = dArray7[0] + dArray[n2] * dArray[n2];
            dArray6[n2] = d2 - this.lambda * (dArray[n2] - d3);
            d2 = dArray[n2];
            d3 = dArray6[n2];
        }
        for (n2 = 1; n2 < dArray3.length; ++n2) {
            dArray7[n2] = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                int n3 = n2;
                dArray7[n3] = dArray7[n3] + dArray6[n] * dArray[n];
                d4 = dArray6[n];
                dArray6[n] = d2 - this.lambda * (d4 - d3);
                d2 = d4;
                d3 = dArray6[n];
            }
        }
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            dArray3[n2] = dArray7[n2];
        }
        double[] dArray8 = new double[62];
        if (dArray3[0] == 0.0) {
            for (n = 1; n < this.numDimensions; ++n) {
                dArray4[n] = 0.0;
                dArray5[n] = 0.0;
            }
        } else {
            int n4;
            for (n4 = 0; n4 < this.numDimensions; ++n4) {
                dArray5[0] = 0.0;
                dArray8[0] = 0.0;
            }
            dArray5[0] = 1.0;
            dArray8[0] = 1.0;
            double d5 = 0.0;
            double d6 = dArray3[0];
            for (int i = 1; i < this.numDimensions; ++i) {
                double d7 = 0.0;
                for (n4 = 1; n4 <= i - 1; ++n4) {
                    d7 += dArray8[n4] * dArray3[i - n4];
                }
                d5 = (dArray3[i] - d7) / d6;
                dArray4[i - 1] = -d5;
                dArray5[i] = d5;
                for (n4 = 1; n4 <= i - 1; ++n4) {
                    dArray5[n4] = dArray8[n4] - d5 * dArray8[i - n4];
                }
                double d8 = (1.0 - d5 * d5) * d6;
                for (int j = 0; j < this.numDimensions; ++j) {
                    dArray8[j] = dArray5[j];
                }
                d6 = d8;
            }
        }
        return dArray4;
    }

    public Object clone() {
        LPC lPC = new LPC();
        lPC.lambda = this.lambda;
        try {
            lPC.setNumDimensions(this.numDimensions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        lPC.parent = this.parent;
        return lPC;
    }

    public String getElement(int n) throws Exception {
        switch (n) {
            case 0: {
                return Double.toString(this.lambda);
            }
            case 1: {
                return Integer.toString(this.numDimensions);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + n + " passed to LPC:getElement()");
    }

    public void setElement(int n, String string) throws Exception {
        switch (n) {
            case 0: {
                try {
                    this.setLambda(Double.parseDouble(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Lambda value must be a double");
                }
            }
            case 1: {
                try {
                    this.setNumDimensions(Integer.parseInt(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Number of Dimensions must be an integer");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index passed to LPC:setElement");
            }
        }
    }

    public void setNumDimensions(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Must have at least 1 LPC coeffecient - " + n + " provided");
        }
        this.numDimensions = n;
        String string = this.definition.name;
        String string2 = this.definition.description;
        String[] stringArray = this.definition.attributes;
        this.definition = new FeatureDefinition(string, string2, true, this.numDimensions, stringArray);
        if (this.parent != null) {
            this.parent.updateTable();
        }
    }

    public void setLambda(double d) throws Exception {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new Exception("lambda must be a real number");
        }
        this.lambda = d;
    }
}

