/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ErrorGUI;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.ProgressFrame;
import jAudioFeatureExtractor.Updater;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ExtractionThread
extends Thread
implements Updater {
    Runnable suspendGUI;
    Runnable resumeGUI;
    ErrorGUI errorGUI;
    UpdateGUI updateGUI;
    Controller controller;
    OuterFrame outerFrame;
    boolean perFile;
    boolean perWindow;
    String valuesSavePath;
    String definitionSavePath;
    int windowSize;
    double windowOverlap;
    boolean hasRun = false;
    ProgressFrame progressFrame;

    public ExtractionThread(Controller controller, OuterFrame outerFrame) {
        this.controller = controller;
        this.outerFrame = outerFrame;
        this.suspendGUI = new Runnable(){

            public void run() {
                ExtractionThread.this.outerFrame.setEnabled(false);
            }
        };
        this.resumeGUI = new Runnable(){

            public void run() {
                ExtractionThread.this.outerFrame.setEnabled(true);
                ExtractionThread.this.progressFrame.setVisible(false);
                JOptionPane.showMessageDialog(null, "Features successfully extracted and saved.", "DONE", 1);
            }
        };
        this.updateGUI = new UpdateGUI();
        controller.dm_.setUpdater(this);
        this.progressFrame = new ProgressFrame();
        this.errorGUI = new ErrorGUI(this.progressFrame);
    }

    public void setup(boolean bl, boolean bl2, String string, String string2, int n, double d) {
        this.perFile = bl;
        this.perWindow = bl2;
        this.valuesSavePath = string;
        this.definitionSavePath = string2;
        this.windowSize = n;
        this.windowOverlap = d;
    }

    public void run() {
        try {
            SwingUtilities.invokeAndWait(this.suspendGUI);
            this.controller.dm_.validateFile(this.definitionSavePath, this.valuesSavePath);
            File file = new File(this.valuesSavePath);
            File file2 = new File(this.definitionSavePath);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            this.controller.dm_.featureKey = fileOutputStream2;
            this.controller.dm_.featureValue = fileOutputStream;
            this.controller.dm_.extract(this.windowSize, this.windowOverlap, this.controller.samplingRateAction.getSamplingRate(), this.controller.normalise.isSelected(), this.perWindow, this.perFile, this.controller.dm_.recordingInfo, this.controller.outputTypeAction.getSelected());
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorGUI.e = exception;
            SwingUtilities.invokeLater(this.errorGUI);
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        this.hasRun = true;
    }

    public void announceUpdate(int n, int n2) {
        this.updateGUI.setPos(n, n2);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    public void announceUpdate(int n) {
        this.updateGUI.setPos(n);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    public void setNumberOfFiles(int n) {
        this.updateGUI.setLengths(n);
    }

    public void setFileLength(int n) {
        this.updateGUI.setMaxWindows(n);
    }

    public boolean hasRun() {
        return this.hasRun();
    }

    class UpdateGUI
    implements Runnable {
        int numberOfFiles;
        int file;
        int thisFileLength = 0;
        int pos;

        UpdateGUI() {
        }

        public void setLengths(int n) {
            this.numberOfFiles = n;
        }

        public void setMaxWindows(int n) {
            this.thisFileLength = n;
        }

        public void setPos(int n, int n2) {
            this.file = n;
            this.pos = n2;
        }

        public void setPos(int n) {
            this.pos = n;
        }

        public void run() {
            ExtractionThread.this.progressFrame.setVisible(true);
            ExtractionThread.this.progressFrame.fileProgressBar.setMaximum(this.thisFileLength);
            ExtractionThread.this.progressFrame.overallProgressBar.setMaximum(this.numberOfFiles);
            ExtractionThread.this.progressFrame.fileProgressBar.setValue(this.pos);
            ExtractionThread.this.progressFrame.overallProgressBar.setValue(this.file);
        }
    }
}

