/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.AggregatorFrame;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.EditFeatures;
import jAudioFeatureExtractor.ExtractionThread;
import jAudioFeatureExtractor.GeneralTools.FeatureDisplay;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.SortingTableModelDecorator;
import jAudioFeatureExtractor.actions.MultipleToggleAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FeatureSelectorPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 1L;
    public OuterFrame outer_frame;
    private MultipleToggleAction multipleToggleAction;
    private JPanel features_panel;
    private JScrollPane features_scroll_pane;
    private JTable features_table;
    private SortingTableModelDecorator decorator;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private JButton extract_features_button;
    private JButton set_aggregators_button;
    private JFileChooser save_file_chooser;
    private AggregatorFrame aggregator_editor = null;
    private EditFeatures ef_ = null;
    private Controller controller;

    public FeatureSelectorPanel(OuterFrame outerFrame, Controller controller) {
        this.outer_frame = outerFrame;
        this.controller = controller;
        this.save_file_chooser = null;
        Color color = new Color(0.75f, 0.85f, 1.0f);
        int n = 6;
        int n2 = 11;
        this.setLayout(new BorderLayout(n, n2));
        this.setUpFeatureTable();
        this.add((Component)new JLabel("FEATURES:"), "North");
        JPanel jPanel = new JPanel(new GridLayout(4, 2, n, n2));
        this.save_window_features_check_box = new JCheckBox("Save Features For Each Window", false);
        this.save_window_features_check_box.setBackground(color);
        this.save_window_features_check_box.addActionListener(this);
        jPanel.add(this.save_window_features_check_box);
        this.save_overall_file_featurese_check_box = new JCheckBox("Save For Overall Recordings", true);
        this.save_overall_file_featurese_check_box.setBackground(color);
        this.save_overall_file_featurese_check_box.addActionListener(this);
        jPanel.add(this.save_overall_file_featurese_check_box);
        jPanel.add(new JLabel("Window Size (samples):"));
        this.window_length_text_field = new JTextArea("512", 1, 20);
        jPanel.add(this.window_length_text_field);
        jPanel.add(new JLabel("Window Overlap (fraction):"));
        this.window_overlap_fraction_text_field = new JTextArea("0.0", 1, 20);
        jPanel.add(this.window_overlap_fraction_text_field);
        this.set_aggregators_button = new JButton("Alter Aggregators");
        this.set_aggregators_button.addActionListener(this);
        jPanel.add(this.set_aggregators_button);
        this.extract_features_button = new JButton("Extract Features");
        this.extract_features_button.addActionListener(this);
        jPanel.add(this.extract_features_button);
        jPanel.setBackground(color);
        this.add((Component)jPanel, "South");
        this.addTableMouseListener();
        this.controller.saveAction.setObjectReferences(this.window_length_text_field, this.window_overlap_fraction_text_field, this.save_window_features_check_box, this.save_overall_file_featurese_check_box);
        this.controller.loadAction.setObjectReferences(this.window_length_text_field, this.window_overlap_fraction_text_field, this.save_window_features_check_box, this.save_overall_file_featurese_check_box);
        this.controller.outputTypeAction.setTarget(outerFrame.ace, outerFrame.arff, this.save_window_features_check_box, this.save_window_features_check_box);
        this.controller.addBatchAction.setSettings(this.save_window_features_check_box, this.save_overall_file_featurese_check_box, this.window_length_text_field, this.window_overlap_fraction_text_field);
        this.controller.viewBatchAction.setFeatureFields(this.save_window_features_check_box, this.save_overall_file_featurese_check_box, this.window_length_text_field, this.window_overlap_fraction_text_field);
        this.controller.dm_.aggregators = new Aggregator[]{(Aggregator)this.controller.dm_.aggregatorMap.get("Standard Deviation").clone(), (Aggregator)this.controller.dm_.aggregatorMap.get("Mean").clone()};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.extract_features_button)) {
            this.extractFeatures();
        } else if (actionEvent.getSource().equals(this.save_overall_file_featurese_check_box)) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected() && this.save_window_features_check_box.isSelected() && this.controller.outputTypeAction.getSelected() == 1) {
                JOptionPane.showMessageDialog(null, "Weka format only supports one type of output - either output per file or output per window.", "ERROR", 0);
                jCheckBox.setSelected(false);
            }
        } else if (actionEvent.getSource().equals(this.save_window_features_check_box)) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected() && this.save_overall_file_featurese_check_box.isSelected() && this.controller.outputTypeAction.getSelected() == 1) {
                JOptionPane.showMessageDialog(null, "Weka format only supports one type of output - either output per file or output per window.", "ERROR", 0);
                jCheckBox.setSelected(false);
            }
        } else if (actionEvent.getSource().equals(this.set_aggregators_button)) {
            this.launchAggEditTable();
        }
    }

    private void extractFeatures() {
        block6: {
            try {
                String string;
                int n;
                int n2;
                boolean bl = this.save_window_features_check_box.isSelected();
                boolean bl2 = this.save_overall_file_featurese_check_box.isSelected();
                String string2 = this.outer_frame.recording_selector_panel.values_save_path_text_field.getText();
                String string3 = this.outer_frame.recording_selector_panel.definitions_save_path_text_field.getText();
                int n3 = Integer.parseInt(this.window_length_text_field.getText());
                double d = Double.parseDouble(this.window_overlap_fraction_text_field.getText());
                boolean bl3 = this.controller.normalise.isSelected();
                double d2 = this.controller.samplingRateAction.getSamplingRate();
                int n4 = this.controller.outputTypeAction.getSelected();
                RecordingInfo[] recordingInfoArray = this.controller.dm_.recordingInfo;
                if (recordingInfoArray == null) {
                    throw new Exception("No recordings available to extract features from.");
                }
                if (n3 >= 0 && n3 != (n2 = Statistics.ensureIsPowerOfN(n3, 2)) && (n = JOptionPane.showConfirmDialog(null, string = "Given window size is " + n3 + ", which is not a power\n" + "of 2. Would you like to increase this to the\n" + "next highest power of 2 (" + n2 + ")?", "WARNING", 0)) == 0) {
                    this.window_length_text_field.setText(String.valueOf(n2));
                    n3 = Integer.parseInt(this.window_length_text_field.getText());
                }
                for (n2 = 0; n2 < this.controller.dm_.defaults.length; ++n2) {
                    this.controller.dm_.defaults[n2] = (Boolean)this.controller.fstm_.getValueAt(n2, 0);
                }
                this.controller.extractionThread = new ExtractionThread(this.controller, this.outer_frame);
                this.controller.extractionThread.setup(bl2, bl, string2, string3, n3, d);
                this.controller.extractionThread.start();
            }
            catch (Throwable throwable) {
                if (throwable.toString().equals("java.lang.OutOfMemoryError")) {
                    JOptionPane.showMessageDialog(null, "The Java Runtime ran out of memory. Please rerun this program\nwith a higher amount of memory assigned to the Java Runtime heap.", "ERROR", 0);
                }
                if (!(throwable instanceof Exception)) break block6;
                Exception exception = (Exception)throwable;
                JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
            }
        }
    }

    private void setUpFeatureTable() {
        this.controller.fstm_.fillTable(this.controller.dm_.featureDefinitions, this.controller.dm_.defaults, this.controller.dm_.is_primary);
        this.decorator = new SortingTableModelDecorator(this.controller.fstm_);
        this.features_table = new JTable(this.decorator);
        this.multipleToggleAction = new MultipleToggleAction(this.features_table);
        String string = "MultipleToggleAction";
        this.features_table.getInputMap().put(KeyStroke.getKeyStroke(' '), string);
        this.features_table.getActionMap().put(string, this.multipleToggleAction);
        int[] nArray = new int[3];
        nArray[0] = this.decorator.getRealPrefferedWidth(this.features_table, 0);
        nArray[1] = this.decorator.getRealPrefferedWidth(this.features_table, 1);
        nArray[1] = nArray[1] - 100;
        nArray[2] = this.decorator.getRealPrefferedWidth(this.features_table, 2);
        for (int i = 0; i < nArray.length; ++i) {
            this.features_table.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
        }
        JTableHeader jTableHeader = this.features_table.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    TableColumnModel tableColumnModel = FeatureSelectorPanel.this.features_table.getColumnModel();
                    int n = FeatureSelectorPanel.this.features_table.convertColumnIndexToModel(tableColumnModel.getColumnIndexAtX(mouseEvent.getX()));
                    FeatureSelectorPanel.this.decorator.sort(n);
                } else {
                    FeatureSelectorPanel.this.decorator.resetIndeci();
                }
            }
        });
        this.features_scroll_pane = new JScrollPane(this.features_table);
        this.features_panel = new JPanel(new GridLayout(1, 1));
        this.features_panel.add(this.features_scroll_pane);
        this.add((Component)this.features_panel, "Center");
        this.controller.fstm_.fireTableDataChanged();
        TableColumn tableColumn = this.features_table.getColumn(this.features_table.getColumnName(1));
        tableColumn.setCellRenderer(new FeatureDisplay());
        this.features_table.removeColumn(this.features_table.getColumn(this.features_table.getColumnName(3)));
        this.repaint();
        this.outer_frame.repaint();
    }

    public void addTableMouseListener() {
        this.features_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = new int[]{FeatureSelectorPanel.this.features_table.rowAtPoint(mouseEvent.getPoint())};
                    FeatureSelectorPanel.this.editDialog(((FeatureSelectorPanel)FeatureSelectorPanel.this).controller.dm_.features[nArray[0]]);
                }
            }
        });
    }

    private void editDialog(FeatureExtractor featureExtractor) {
        this.ef_ = new EditFeatures(this, featureExtractor);
        this.ef_.setVisible(true);
    }

    private void launchAggEditTable() {
        this.aggregator_editor = new AggregatorFrame(this.controller);
        this.aggregator_editor.setVisible(true);
    }
}

