/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.XMLParsers.FileFilterXML;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.FeatureSelectorTableModel;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class LoadAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private FeatureSelectorTableModel fstm_;
    private JFileChooser save_file_chooser = null;
    private Controller controller;

    public LoadAction(Controller controller, FeatureSelectorTableModel featureSelectorTableModel) {
        super("Load Settings...");
        this.fstm_ = featureSelectorTableModel;
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.save_file_chooser == null) {
            this.save_file_chooser = new JFileChooser();
            this.save_file_chooser.setCurrentDirectory(new File("."));
            this.save_file_chooser.setFileFilter(new FileFilterXML());
        }
        String string = null;
        int n = this.save_file_chooser.showOpenDialog(null);
        if (n == 0) {
            File file = this.save_file_chooser.getSelectedFile();
            string = file.getPath();
            String string2 = StringMethods.getExtension(string);
            if (string2 == null) {
                string = string + ".xml";
                file = new File(string);
            } else if (!string2.equals(".xml")) {
                string = StringMethods.removeExtension(string) + ".xml";
                file = new File(string);
            }
            if (!file.exists()) {
                JOptionPane.showMessageDialog(null, "The file '" + file.getName() + "' does not exist", "ERROR", 0);
            } else {
                try {
                    String[] stringArray;
                    Object object;
                    Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "save_settings");
                    this.window_length_text_field.setText((String)objectArray[0]);
                    this.window_overlap_fraction_text_field.setText((String)objectArray[1]);
                    double d = (Double)objectArray[2];
                    if (d <= 8000.0) {
                        this.controller.samplingRateAction.setSelected(0);
                    } else if (d <= 11025.0) {
                        this.controller.samplingRateAction.setSelected(1);
                    } else if (d <= 16000.0) {
                        this.controller.samplingRateAction.setSelected(2);
                    } else if (d <= 22050.0) {
                        this.controller.samplingRateAction.setSelected(3);
                    } else {
                        this.controller.samplingRateAction.setSelected(4);
                    }
                    this.controller.normalise.setSelected((Boolean)objectArray[3]);
                    this.save_window_features_check_box.setSelected((Boolean)objectArray[4]);
                    this.save_overall_file_featurese_check_box.setSelected((Boolean)objectArray[5]);
                    if (objectArray[6].equals("ACE")) {
                        this.controller.outputTypeAction.setSelected(0);
                    } else {
                        this.controller.outputTypeAction.setSelected(1);
                    }
                    HashMap hashMap = (HashMap)objectArray[7];
                    HashMap hashMap2 = (HashMap)objectArray[8];
                    for (int i = 0; i < this.fstm_.getRowCount(); ++i) {
                        object = (String)this.fstm_.getValueAt(i, 1);
                        if (hashMap2.containsKey(object) && hashMap.containsKey(object)) {
                            this.fstm_.setValueAt(hashMap.get(object), i, 0);
                            stringArray = (String[])hashMap2.get(object);
                            for (int j = 0; j < stringArray.length; ++j) {
                                this.controller.dm_.features[i].setElement(j, stringArray[j]);
                            }
                            continue;
                        }
                        this.fstm_.setValueAt(Boolean.FALSE, i, 0);
                    }
                    this.fstm_.fireTableDataChanged();
                    LinkedList linkedList = (LinkedList)objectArray[9];
                    object = (LinkedList)objectArray[10];
                    stringArray = (String[])objectArray[11];
                    LinkedList<Aggregator> linkedList2 = new LinkedList<Aggregator>();
                    Iterator iterator = linkedList.iterator();
                    Iterator iterator2 = ((AbstractSequentialList)object).iterator();
                    Iterator iterator3 = stringArray.iterator();
                    while (iterator.hasNext()) {
                        Aggregator aggregator = this.controller.dm_.aggregatorMap.get(iterator.next());
                        aggregator.setParameters((String[])iterator2.next(), (String[])iterator3.next());
                        linkedList2.add(aggregator);
                    }
                    this.controller.dm_.aggregators = linkedList2.toArray(new Aggregator[0]);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                }
            }
        }
    }

    public void setObjectReferences(JTextArea jTextArea, JTextArea jTextArea2, JCheckBox jCheckBox, JCheckBox jCheckBox2) {
        this.window_length_text_field = jTextArea;
        this.window_overlap_fraction_text_field = jTextArea2;
        this.save_window_features_check_box = jCheckBox;
        this.save_overall_file_featurese_check_box = jCheckBox2;
    }
}

