/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Controller;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LoadBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    Controller controller;

    public LoadBatchAction(Controller controller) {
        super("Load Batchfile...");
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(null);
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            try {
                this.controller.batches.clear();
                Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(file.getAbsolutePath(), "batchFile");
                for (int i = 0; i < objectArray.length; ++i) {
                    this.controller.batches.add((Batch)objectArray[i]);
                    this.controller.batches.get(i).setDataModel(this.controller.dm_);
                    JMenuItem jMenuItem = new JMenuItem(this.controller.batches.get(i).getName());
                    jMenuItem.addActionListener(this.controller.removeBatchAction);
                    this.controller.removeBatch.add(jMenuItem);
                    JMenuItem jMenuItem2 = new JMenuItem(this.controller.batches.get(i).getName());
                    jMenuItem2.addActionListener(this.controller.viewBatchAction);
                    this.controller.viewBatch.add(jMenuItem2);
                }
                if (this.controller.batches.size() > 0) {
                    this.controller.removeBatch.setEnabled(true);
                    this.controller.viewBatch.setEnabled(true);
                }
                JOptionPane.showMessageDialog(null, "Loading of batch file successful.", "Information", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
            }
        }
    }
}

