/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JRadioButtonMenuItem;

public class SamplingRateAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private int sampleRateIndex = 2;
    public JRadioButtonMenuItem[] samplingRates;

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.samplingRates.length; ++i) {
            if (!actionEvent.getSource().equals(this.samplingRates[i])) continue;
            this.sampleRateIndex = i;
        }
    }

    public void setTarget(JRadioButtonMenuItem[] jRadioButtonMenuItemArray) {
        this.samplingRates = new JRadioButtonMenuItem[jRadioButtonMenuItemArray.length];
        for (int i = 0; i < this.samplingRates.length; ++i) {
            this.samplingRates[i] = jRadioButtonMenuItemArray[i];
        }
    }

    public int getSelected() {
        return this.sampleRateIndex;
    }

    public double getSamplingRate() {
        double d = Double.parseDouble(this.samplingRates[this.sampleRateIndex].getText());
        return d * 1000.0;
    }

    public void setSelected(int n) {
        if (n < 0 || n >= this.samplingRates.length) {
            System.err.println("INTERNAL ERROR: " + n + " does not correspond to any sampling rate index");
        } else {
            this.samplingRates[n].setSelected(true);
            this.sampleRateIndex = n;
        }
    }
}

