/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.GeneralTools.Statistics;

public class FFT {
    private double[] real_output;
    private double[] imaginary_output;
    private double[] output_angle;
    private double[] output_magnitude;
    private double[] output_power;

    public FFT(double[] dArray, double[] dArray2, boolean bl, boolean bl2) throws Exception {
        int n;
        double d;
        int n2;
        if (dArray2 != null && dArray.length != dArray2.length) {
            throw new Exception("Imaginary and real inputs are of different sizes.");
        }
        if (dArray.length < 3) {
            throw new Exception("Only " + dArray.length + " samples provided.\n" + "At least three are needed.");
        }
        int n3 = Statistics.ensureIsPowerOfN(dArray.length, 2);
        if (n3 != dArray.length) {
            int n4;
            double[] dArray3 = new double[n3];
            for (n4 = 0; n4 < dArray.length; ++n4) {
                dArray3[n4] = dArray[n4];
            }
            for (n4 = dArray.length; n4 < n3; ++n4) {
                dArray3[n4] = 0.0;
            }
            dArray = dArray3;
            if (dArray2 == null) {
                dArray2 = new double[n3];
                for (n4 = 0; n4 < dArray2.length; ++n4) {
                    dArray2[n4] = 0.0;
                }
            } else {
                dArray3 = new double[n3];
                for (n4 = 0; n4 < dArray2.length; ++n4) {
                    dArray3[n4] = dArray2[n4];
                }
                for (n4 = dArray2.length; n4 < n3; ++n4) {
                    dArray3[n4] = 0.0;
                }
                dArray2 = dArray3;
            }
        } else if (dArray2 == null) {
            dArray2 = new double[n3];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = 0.0;
            }
        }
        this.real_output = new double[n3];
        System.arraycopy(dArray, 0, this.real_output, 0, n3);
        this.imaginary_output = new double[n3];
        System.arraycopy(dArray2, 0, this.imaginary_output, 0, n3);
        if (bl2) {
            int n5 = 0;
            while (n5 < this.real_output.length) {
                double d2 = 0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)n5 / (double)n3);
                int n6 = n5++;
                this.real_output[n6] = this.real_output[n6] * d2;
            }
        }
        int n7 = 1;
        if (bl) {
            n7 = -1;
        }
        double d3 = 1.0;
        int n8 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n8 >= n2) {
                double d4 = this.real_output[n8] * d3;
                d = this.imaginary_output[n8] * d3;
                this.real_output[n8] = this.real_output[n2] * d3;
                this.imaginary_output[n8] = this.imaginary_output[n2] * d3;
                this.real_output[n2] = d4;
                this.imaginary_output[n2] = d;
            }
            for (n = n3 / 2; n >= 1 && n8 >= n; n8 -= n, n /= 2) {
            }
            n8 += n;
        }
        n2 = 0;
        n = 1;
        int n9 = 2 * n;
        while (n < n3) {
            d = (double)n7 * Math.PI / (double)n;
            for (int i = 0; i < n; ++i) {
                double d5 = (double)i * d;
                double d6 = Math.cos(d5);
                double d7 = Math.sin(d5);
                int n10 = 0;
                for (int j = i; j < n3; j += n9) {
                    n10 = j + n;
                    double d8 = d6 * this.real_output[n10] - d7 * this.imaginary_output[n10];
                    double d9 = d6 * this.imaginary_output[n10] + d7 * this.real_output[n10];
                    this.real_output[n10] = this.real_output[j] - d8;
                    this.imaginary_output[n10] = this.imaginary_output[j] - d9;
                    int n11 = j;
                    this.real_output[n11] = this.real_output[n11] + d8;
                    int n12 = j;
                    this.imaginary_output[n12] = this.imaginary_output[n12] + d9;
                }
            }
            n = n9;
            n = n9;
            n9 = 2 * n;
        }
        this.output_angle = null;
        this.output_power = null;
        this.output_magnitude = null;
    }

    public double[] getMagnitudeSpectrum() {
        if (this.output_magnitude == null) {
            int n = this.imaginary_output.length / 2;
            this.output_magnitude = new double[n];
            for (int i = 0; i < this.output_magnitude.length; ++i) {
                this.output_magnitude[i] = Math.sqrt(this.real_output[i] * this.real_output[i] + this.imaginary_output[i] * this.imaginary_output[i]) / (double)this.real_output.length;
            }
        }
        return this.output_magnitude;
    }

    public double[] getPowerSpectrum() {
        if (this.output_power == null) {
            int n = this.imaginary_output.length / 2;
            this.output_power = new double[n];
            for (int i = 0; i < this.output_power.length; ++i) {
                this.output_power[i] = (this.real_output[i] * this.real_output[i] + this.imaginary_output[i] * this.imaginary_output[i]) / (double)this.real_output.length;
            }
        }
        return this.output_power;
    }

    public double[] getPhaseAngles() {
        if (this.output_angle == null) {
            int n = this.imaginary_output.length / 2;
            this.output_angle = new double[n];
            for (int i = 0; i < this.output_angle.length; ++i) {
                this.output_angle[i] = this.imaginary_output[i] == 0.0 && this.real_output[i] == 0.0 ? 0.0 : Math.atan(this.imaginary_output[i] / this.real_output[i]) * 180.0 / Math.PI;
                if (this.real_output[i] < 0.0 && this.imaginary_output[i] == 0.0) {
                    this.output_angle[i] = 180.0;
                    continue;
                }
                if (this.real_output[i] < 0.0 && this.imaginary_output[i] == -0.0) {
                    this.output_angle[i] = -180.0;
                    continue;
                }
                if (this.real_output[i] < 0.0 && this.imaginary_output[i] > 0.0) {
                    int n2 = i;
                    this.output_angle[n2] = this.output_angle[n2] + 180.0;
                    continue;
                }
                if (!(this.real_output[i] < 0.0) || !(this.imaginary_output[i] < 0.0)) continue;
                int n3 = i;
                this.output_angle[n3] = this.output_angle[n3] + -180.0;
            }
        }
        return this.output_angle;
    }

    public double[] getBinLabels(double d) {
        int n = this.real_output.length;
        double d2 = d / (double)n;
        int n2 = this.imaginary_output.length / 2;
        double[] dArray = new double[n2];
        dArray[0] = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = (double)i * d2;
        }
        return dArray;
    }

    public double[] getRealValues() {
        return this.real_output;
    }

    public double[] getImaginaryValues() {
        return this.imaginary_output;
    }
}

