/*
 * Decompiled with CFR 0.152.
 */
package org.oc.ocvolume.dsp;

import org.oc.ocvolume.dsp.fft;

public class featureExtraction {
    protected static final int frameLength = 512;
    protected static final int shiftInterval = 256;
    public int numCepstra = 13;
    protected static final int fftSize = 512;
    protected static final double preEmphasisAlpha = 0.95;
    protected static final double lowerFilterFreq = 133.3334;
    protected static final double upperFilterFreq = 6855.4976;
    protected static final int numMelFilters = 23;
    protected double[][] frames;
    protected double[] hammingWindow;
    protected fft FFT;

    public double[][] process(short[] sArray, double d) {
        double[] dArray = featureExtraction.preEmphasis(sArray);
        this.framing(dArray);
        double[][] dArray2 = new double[this.frames.length][this.numCepstra];
        this.hammingWindow();
        for (int i = 0; i < this.frames.length; ++i) {
            this.FFT = new fft();
            double[] dArray3 = this.magnitudeSpectrum(this.frames[i]);
            int[] nArray = this.fftBinIndices(d, 512);
            double[] dArray4 = this.melFilter(dArray3, nArray);
            double[] dArray5 = this.nonLinearTransformation(dArray4);
            double[] dArray6 = this.cepCoefficients(dArray5);
            for (int j = 0; j < this.numCepstra; ++j) {
                dArray2[i][j] = dArray6[j];
            }
        }
        return dArray2;
    }

    public int[] fftBinIndices(double d, int n) {
        int[] nArray = new int[25];
        nArray[0] = (int)Math.round(133.3334 / d * (double)n);
        nArray[nArray.length - 1] = n / 2;
        for (int i = 1; i <= 23; ++i) {
            double d2 = featureExtraction.centerFreq(i, d);
            nArray[i] = (int)Math.round(d2 / d * (double)n);
        }
        return nArray;
    }

    public double[] melFilter(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[25];
        for (int i = 1; i <= 23; ++i) {
            int n;
            double d = 0.0;
            double d2 = 0.0;
            for (n = nArray[i - 1]; n <= nArray[i]; ++n) {
                d += (double)((n - nArray[i - 1] + 1) / (nArray[i] - nArray[i - 1] + 1)) * dArray[n];
            }
            for (n = nArray[i] + 1; n <= nArray[i + 1]; ++n) {
                d2 += (double)(1 - (n - nArray[i]) / (nArray[i + 1] - nArray[i] + 1)) * dArray[n];
            }
            dArray2[i] = d + d2;
        }
        double[] dArray3 = new double[23];
        for (int i = 0; i < 23; ++i) {
            dArray3[i] = dArray2[i + 1];
        }
        return dArray3;
    }

    public double[] cepCoefficients(double[] dArray) {
        double[] dArray2 = new double[this.numCepstra];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 1; j <= 23; ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[j - 1] * Math.cos(Math.PI * (double)i / 23.0 * ((double)j - 0.5));
            }
        }
        return dArray2;
    }

    public double[] nonLinearTransformation(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.log(dArray[i]);
            if (!(dArray2[i] < -50.0)) continue;
            dArray2[i] = -50.0;
        }
        return dArray2;
    }

    protected static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private static double centerFreq(int n, double d) {
        double[] dArray = new double[]{featureExtraction.freqToMel(133.3334), featureExtraction.freqToMel(d / 2.0)};
        double d2 = dArray[0] + (dArray[1] - dArray[0]) / 24.0 * (double)n;
        return featureExtraction.inverseMel(d2);
    }

    private static double inverseMel(double d) {
        double d2 = Math.pow(10.0, d / 2595.0) - 1.0;
        return 700.0 * d2;
    }

    protected static double freqToMel(double d) {
        return 2595.0 * featureExtraction.log10(1.0 + d / 700.0);
    }

    public double[] magnitudeSpectrum(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        fft.computeFFT(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(fft.real[i] * fft.real[i] + fft.imag[i] * fft.imag[i], 0.5);
        }
        return dArray2;
    }

    private void hammingWindow() {
        int n;
        double[] dArray = new double[512];
        for (n = 0; n < 512; ++n) {
            dArray[n] = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)n / 511.0);
        }
        for (n = 0; n < this.frames.length; ++n) {
            for (int i = 0; i < 512; ++i) {
                double[] dArray2 = this.frames[n];
                int n2 = i;
                dArray2[n2] = dArray2[n2] * dArray[i];
            }
        }
    }

    protected void framing(double[] dArray) {
        int n;
        double d = (double)dArray.length / 256.0;
        if (d / (double)((int)d) != 1.0) {
            d = (int)d + 1;
        }
        double[] dArray2 = new double[(int)d * 512];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n];
        }
        this.frames = new double[(int)d][512];
        n = 0;
        while ((double)n < d) {
            for (int i = 0; i < 512; ++i) {
                this.frames[n][i] = dArray2[n * 256 + i];
            }
            ++n;
        }
    }

    protected static double[] preEmphasis(short[] sArray) {
        double[] dArray = new double[sArray.length];
        for (int i = 1; i < sArray.length; ++i) {
            dArray[i] = (double)sArray[i] - 0.95 * (double)sArray[i - 1];
        }
        return dArray;
    }
}

