package jp.crestmuse.cmx.amusaj.sp;

import jAudioFeatureExtractor.jAudioTools.*;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jp.crestmuse.cmx.math.*;

public class jAudioFeatureExtractor extends FeatureProcessor 
  implements jp.crestmuse.cmx.amusaj.sp.FeatureExtractor<DoubleArray> {

  private double[][][] results;
  private static final int[] window_start_indices = new int[]{0};
  private int[] indexmap;
  private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
  
  public jAudioFeatureExtractor(int window_size, double sampling_rate, 
                                FeatureExtractor[] all_feature_extractors, 
                                boolean[] features_to_save_among_all) 
    {
      super(window_size, sampling_rate, all_feature_extractors, 
            features_to_save_among_all);
  }

  public void extractFeatures(DoubleArray wav) {
    try {
      results = getFeatures(wav.toArray(), window_start_indices);
    } catch (Exception e) {
      throw new SPException(e);
    }
  }

  public DoubleArray getFeature(int index) {
    double[] feats = results[0][index];
    if (feats == null)
      return null;
    else
      return factory.createArray(feats);
  }

  public String getFeatureType(int index) {
    return feature_extractors[index].getFeatureDefinition().name;
  }

  public int nFeatureTypes() {
    return feature_extractors.length;
  }
}
