/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.analysis.AnalysisAdapter;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.lexer.LexerException;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.EOF;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TErroneousEscape;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TEvenBackslash;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TRawInputCharacter;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TSub;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TUnicodeEscape;

public class UnicodePreprocessor
extends Reader {
    private UnicodeLexer lexer;
    private ProcessToken processor = new ProcessToken();
    int available;
    char[] buffer = new char[2];

    public UnicodePreprocessor(PushbackReader pushbackReader) {
        this.lexer = new UnicodeLexer(pushbackReader);
    }

    @Override
    public int read() throws IOException {
        if (this.available == 0) {
            try {
                this.lexer.next().apply(this.processor);
            }
            catch (LexerException lexerException) {
                throw new RuntimeException(lexerException.toString());
            }
        }
        if (this.available == 0) {
            return -1;
        }
        char c = this.buffer[0];
        this.buffer[0] = this.buffer[1];
        --this.available;
        return c;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    @Override
    public void close() {
    }

    private class ProcessToken
    extends AnalysisAdapter {
        private ProcessToken() {
        }

        @Override
        public void caseTEvenBackslash(TEvenBackslash tEvenBackslash) {
            UnicodePreprocessor.this.buffer[0] = 92;
            UnicodePreprocessor.this.buffer[1] = 92;
            UnicodePreprocessor.this.available = 2;
        }

        @Override
        public void caseTUnicodeEscape(TUnicodeEscape tUnicodeEscape) {
            String string = tUnicodeEscape.getText();
            UnicodePreprocessor.this.buffer[0] = (char)Integer.parseInt(string.substring(string.length() - 4), 16);
            UnicodePreprocessor.this.available = 1;
        }

        @Override
        public void caseTErroneousEscape(TErroneousEscape tErroneousEscape) {
            throw new RuntimeException("Erroneous escape: " + tErroneousEscape);
        }

        @Override
        public void caseTSub(TSub tSub) {
            UnicodePreprocessor.this.buffer[0] = tSub.getText().charAt(0);
            UnicodePreprocessor.this.available = 1;
        }

        @Override
        public void caseTRawInputCharacter(TRawInputCharacter tRawInputCharacter) {
            UnicodePreprocessor.this.buffer[0] = tRawInputCharacter.getText().charAt(0);
            UnicodePreprocessor.this.available = 1;
        }

        @Override
        public void caseEOF(EOF eOF) {
            UnicodePreprocessor.this.available = 0;
        }
    }
}

