/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.grammars.java_1_5.unicodepreprocessor.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.lexer.LexerException;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.EOF;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TErroneousEscape;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TEvenBackslash;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TRawInputCharacter;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TSub;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.TUnicodeEscape;
import org.sablecc.grammars.java_1_5.unicodepreprocessor.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.NORMAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader pushbackReader) {
        this.in = pushbackReader;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token token = this.token;
        this.token = null;
        return token;
    }

    protected Token getToken() throws IOException, LexerException {
        int n = 0;
        int n2 = this.pos;
        int n3 = this.line;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int[][][] nArray = gotoTable[this.state.id()];
        int[] nArray2 = accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int n9;
            if ((n9 = this.getChar()) != -1) {
                switch (n9) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)n9);
                block16: do {
                    int n10 = n < -1 ? -2 - n : n;
                    n = -1;
                    int[][] nArray3 = nArray[n10];
                    int n11 = 0;
                    int n12 = nArray3.length - 1;
                    while (n11 <= n12) {
                        int n13 = (n11 + n12) / 2;
                        int[] nArray4 = nArray3[n13];
                        if (n9 < nArray4[0]) {
                            n12 = n13 - 1;
                            continue;
                        }
                        if (n9 > nArray4[1]) {
                            n11 = n13 + 1;
                            continue;
                        }
                        n = nArray4[2];
                        continue block16;
                    }
                } while (n < -1);
            } else {
                n = -1;
            }
            if (n >= 0) {
                if (nArray2[n] == -1) continue;
                n4 = n;
                n5 = nArray2[n];
                n6 = this.text.length();
                n7 = this.pos;
                n8 = this.line;
                continue;
            }
            if (n4 == -1) break;
            switch (n5) {
                case 0: {
                    Token token = this.new0(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 1: {
                    Token token = this.new1(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 2: {
                    Token token = this.new2(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 3: {
                    Token token = this.new3(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.SUB;
                            break;
                        }
                        case 1: {
                            this.state = State.SUB;
                        }
                    }
                    return token;
                }
                case 4: {
                    Token token = this.new4(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (n3 + 1) + "," + (n2 + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF eOF = new EOF(n3 + 1, n2 + 1);
        return eOF;
    }

    Token new0(int n, int n2) {
        return new TEvenBackslash(n, n2);
    }

    Token new1(String string, int n, int n2) {
        return new TUnicodeEscape(string, n, n2);
    }

    Token new2(String string, int n, int n2) {
        return new TErroneousEscape(string, n, n2);
    }

    Token new3(String string, int n, int n2) {
        return new TSub(string, n, n2);
    }

    Token new4(String string, int n, int n2) {
        return new TRawInputCharacter(string, n, n2);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            this.eof = true;
        }
        return n;
    }

    private void pushBack(int n) throws IOException {
        int n2 = this.text.length();
        for (int i = n2 - 1; i >= n; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String string = token.getText();
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(string.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.text.charAt(i));
        }
        return stringBuffer.toString();
    }

    static {
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int n3 = dataInputStream.readInt();
            gotoTable = new int[n3][][][];
            for (n2 = 0; n2 < gotoTable.length; ++n2) {
                n3 = dataInputStream.readInt();
                Lexer.gotoTable[n2] = new int[n3][][];
                for (n = 0; n < gotoTable[n2].length; ++n) {
                    n3 = dataInputStream.readInt();
                    Lexer.gotoTable[n2][n] = new int[n3][3];
                    for (int i = 0; i < gotoTable[n2][n].length; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            Lexer.gotoTable[n2][n][i][j] = dataInputStream.readInt();
                        }
                    }
                }
            }
            n3 = dataInputStream.readInt();
            accept = new int[n3][];
            for (n2 = 0; n2 < accept.length; ++n2) {
                n3 = dataInputStream.readInt();
                Lexer.accept[n2] = new int[n3];
                for (n = 0; n < accept[n2].length; ++n) {
                    Lexer.accept[n2][n] = dataInputStream.readInt();
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    public static class State {
        public static final State NORMAL = new State(0);
        public static final State SUB = new State(1);
        private int id;

        private State(int n) {
            this.id = n;
        }

        public int id() {
            return this.id;
        }
    }
}

