﻿using System;
using System.Xml.Linq;
using Paraiba.Core;
using System.Diagnostics;
using System.IO;
using Paraiba.IO;
using Paraiba.Text;

namespace CoverageFramework.AstGenerator
{
	public abstract class AstGenerator : IAstGenerator
	{
		protected abstract string ProcessorPath { get; }

		protected abstract string[] Arguments { get; }

		public XDocument GenerateXml(string inFilePath)
		{
			using (var reader = new StreamReader(inFilePath, XEncoding.SJIS))
			{
				return GenerateXml(reader);
			}
		}

		public XDocument GenerateXml(TextReader reader)
		{
			var info = new ProcessStartInfo {
				FileName = ProcessorPath,
				Arguments = Arguments.JoinString(" "),
				CreateNoWindow = true,
				RedirectStandardInput = true,
				RedirectStandardOutput = true,
				UseShellExecute = false,
			};
			using (var p = Process.Start(info))
			{
				p.StandardInput.WriteFromStream(reader);
				p.StandardInput.Close();
				return XDocument.Load(p.StandardOutput);
			}
		}
	}
}