﻿using System.Xml.Linq;
using System.ComponentModel.Composition;

namespace CoverageFramework.CodeGenerator.Java
{
	[Export(typeof(ISourceCodeGenerator))]
	public class SourceCodeGeneratorForJava : SourceCodeGenerator
	{
		protected override bool TreatTerminalSymbol(XElement element)
		{
			switch (element.Name.LocalName)
			{
			case "TSemi":
				WriteLine(";");
				break;

			case "TLBrc":
				WriteLine("{");
				Depth++;
				break;

			case "TRBrc":
				Depth--;
				WriteLine("}");
				break;

			default:
				return false;
			}

			return true;
		}
	}
}