﻿using System.Xml.Linq;
using System.ComponentModel.Composition;

namespace CoverageFramework.CodeGenerator.Python
{
	[Export(typeof(ISourceCodeGenerator))]
	public class SourceCodeGeneratorForPython : SourceCodeGenerator
	{
		protected override bool TreatTerminalSymbol(XElement element)
		{
			switch (element.Name.LocalName)
			{
			case "NEWLINE":
				WriteLine();
				break;

			case "INDENT":
				Depth++;
				break;

			case "DEDENT":
				Depth--;
				break;

			default:
				return false;
			}

			return true;
		}
	}
}