using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using CoverageFramework.Operator.Generator;
using CoverageFramework.Operator.Selector;
using CoverageFramework.Model;
using CoverageFramework.Utility;
using Paraiba.Linq;

namespace CoverageFramework.Embedder
{
	public class StatementCoverageEmbedder
	{
		private int _iStatement;

		public void Embed(XElement root, IXElementRangeSelector statementRangeSelector, ITaggedXElementGenerator covGen, ITagger tagger, IDictionary<string, CoverageInfomation> covInfos)
		{
			statementRangeSelector.Select(root).ToList()
				.ForEach(target => {
					var key = "stmt," + (_iStatement++);
					var pos = CodePositionUtil.CreateCodePosition(target);
					covInfos[key] = new CoverageInfomation(pos, tagger.Generate(target));

					target.First().AddBeforeSelf(covGen.Generate(key));
				});
		}

		public IList<XElement> GetTargetElements(XElement root, IXElementSelector statementSelector, IList<CoverageInfomation> covInfos)
		{
			var list = statementSelector.Select(root).ToList();



			return list;
		}

		public void Embed(IList<XElement> elements, IXElementSelector statementSelector, IStatementGenerator covGen, ITagger tagger, IList<CoverageInfomation> covInfos)
		{
			//statementSelector.Select(root).ToList()
			//    .ForEach(target => {
			//        target.AddBeforeSelf(covGen.Generate());

			//        var pos = CodePositionUtil.CreateCodePosition(target);
			//        covInfos.Add(new CoverageInfomation(pos, tagger.Generate(target)));
			//    });
		}

		public void Count(XElement root, IXElementSelector statementSelector)
		{
			//return statementSelector.Select(root).Count();
		}
	}
}