﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using Paraiba.Xml.Linq;

namespace CoverageFramework.Embedder
{
	public interface ITagger
	{
		string Generate(XElement elements);
		string Generate(IEnumerable<XElement> elements);
	}

	public class Tagger : ITagger
	{
		private readonly string _additionalPath;

		public Tagger(string additionalPath)
		{
			_additionalPath = additionalPath;
		}

		public string Generate(XElement elements)
		{
			try
			{
				var element = elements.Parents()
					.Where(e => e.Name.LocalName == "AClassBody");
				var target = element.First().NodesBeforeSelf()
					.FirstOrDefault(e => ((XElement)e).Name.LocalName == "TIdentifier");
				if (target != null)
				{
					return (_additionalPath + "\\" + ((XElement)target).Value).Replace('\\', '>');
				}
			} catch (Exception)
			{
			}
			return _additionalPath.Replace('\\', '>');
		}

		public string Generate(IEnumerable<XElement> elements)
		{
			return Generate(elements.FirstOrDefault());
		}
	}
}
