﻿using System;

namespace CoverageFramework.Model
{
	[Serializable]
	public struct CodePosition
	{
		public int EndID;
		public int EndLine;
		public int EndPos;
		public int StartID;
		public int StartLine;
		public int StartPos;

		public CodePosition(int startLine, int startPos, int startID, int endLine, int endPos, int endID)
		{
			StartLine = startLine;
			StartPos = startPos;
			StartID = startID;
			EndLine = endLine;
			EndPos = endPos;
			EndID = endID;
		}

		public bool Equals(CodePosition pos)
		{
			return StartLine == pos.StartLine
				&& StartPos == pos.StartPos
				&& StartID == pos.StartID
				&& EndLine == pos.EndLine
				&& EndPos == pos.EndPos
				&& EndID == pos.EndID;
		}

		public override bool Equals(object obj)
		{
			if (!(obj is CodePosition))
				return false;
			return Equals((CodePosition)obj);
		}

		public override int GetHashCode()
		{
			return StartLine.GetHashCode()
				^ StartPos.GetHashCode()
				^ StartID.GetHashCode()
				^ EndLine.GetHashCode()
				^ EndPos.GetHashCode()
				^ EndID.GetHashCode();
		}

		public override string ToString()
		{
			var line = StartLine == EndLine ? StartLine.ToString() : (StartLine + " - " + EndLine);
			var pos = StartPos == EndPos ? StartPos.ToString() : (StartPos + " - " + EndPos);
			return "Line: " + line + ", Pos: " + pos;
		}
	}
}