using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public class AtomicBooleanTermSelectorForC : AtomicBooleanTermSelector
	{
		private static readonly string[] CondComponentNames = new[] {
			"logical_or_expression",
			"logical_and_expression",
			"primary_expression", // ʂŊƏo
		};

		private static readonly string[] CondNames = new[] {
			"logical_or_expression",
			"logical_and_expression",
		};

		private static readonly string[] CondOpValues = new[] {
			"||",
			"&&",
		};

		protected override bool IsBoolTermSepartor(XElement element)
		{
			return !element.HasElements && CondOpValues.Contains(element.Value);
		}

		protected override bool IsConditionalExpression(XElement element)
		{
			return CondNames.Contains(element.Name.LocalName);
		}

		protected override bool IsConditionalExpressionComponent(XElement element)
		{
			return CondComponentNames.Contains(element.Name.LocalName);
		}
	}
}