using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public abstract class ControlFlowSelectorForC : IXElementRangeSelector
	{
		private readonly string[] _names, _values;

		protected ControlFlowSelectorForC(string[] names, string[] values)
		{
			_names = names;
			_values = values;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			yield return root
				// SĂifvf
				.Descendants()
				.Where(e_ => _names.Any(e_.Name.LocalName.Equals))
				.Where(e_ => {
					// switch̏
					var e2_ = e_.Elements().FirstOrDefault();
					return e2_ != null && !e2_.HasElements && _values.Contains(e2_.Value);
				});
		}

		#endregion
	}
}