using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public abstract class ControlFlowStatementSelectorForC : IXElementRangeSelector
	{
		private readonly string _value;

		protected ControlFlowStatementSelectorForC(string value)
		{
			_value = value;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var result = root
				.Elements()
				.SkipWhile(e_ => !(!e_.HasElements && e_.Value == _value))
				.Skip(1)
				.Take(1);
			if (!result.IsEmpty())
				yield return result;
		}

		#endregion
	}
}