using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public class IfElseStatementSelectorForC : IXElementRangeSelector
	{
		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var targetSource = root
				.Elements()
				.SkipWhile(e_ => !(!e_.HasElements && e_.Value == ")"))
				.Skip(1);
			{
				var result = targetSource
					.Take(1);
				if (!result.IsEmpty())
					yield return result;
			}

			{
				var result = targetSource
					.SkipWhile(e_ => !(!e_.HasElements && e_.Value == "else"))
					.Skip(1)
					.Take(1);
				if (!result.IsEmpty())
					yield return result;
			}
		}

		#endregion
	}
}