using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using CoverageFramework.Utility;

namespace CoverageFramework.Operator.Selector.C
{
	public class LackingBlockStatementSelectorForC : IXElementRangeSelector
	{
		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var ifSelector = XElementSelectorUtil.Chain(
				new IfSelectorForC(),
				new IfElseStatementSelectorForC());

			var whileForSelector = XElementSelectorUtil.Chain(
				XElementSelectorUtil.Merge(
					new WhileSelectorForC(),
					new ForSelectorForC()),
				new WhileForStatementSelectorForC());

			var doWhileSelector = XElementSelectorUtil.Chain(
				new DoWhileSelectorForC(),
				new DoWhileStatementSelectorForC());

			return XElementSelectorUtil.Merge(ifSelector, whileForSelector, doWhileSelector)
				.Select(root)
				.Where(block_ => block_.First().Name.LocalName != "compound_statement");
		}

		#endregion
	}
}