﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C2
{
	[Export(typeof(IXElementSelector))]
	public class IfConditionSelector : IXElementSelector
	{
		private static readonly string[] IfStatementNames = {
			// If
			"selection_statement",
		};

		public IEnumerable<XElement> Select(XElement root)
		{
			return root.Descendants()
				.Where(e => IfStatementNames.Contains(e.Name.LocalName))
				.Where(e => e.Elements().First().Value == "if")
				.Select(e => e.Elements().First(e2 => e2.Name.LocalName == "expression"));
		}
	}
}
