﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C2
{
	[Export(typeof(IXElementSelector))]
	public class LackingBlockSelector : XElementSelector
	{
		private static readonly string[] ParentNames = {
			"selection_statement",
			"iteration_statement",
		};

		private static readonly string[] StatementNames = {
			"statement",
		};

		protected override IEnumerable<XElement> SelectContainingNull(XElement root)
		{
			return root.Descendants()
				.Where(e => ParentNames.Contains(e.Name.LocalName))
				.Select(e => e.Elements()
					.FirstOrDefault(e2 => StatementNames.Contains(e2.Name.LocalName)));
		}
	}
}
