﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C2
{
	[Export(typeof(IXElementSelector))]
	public class SimpleStatementSelector : IXElementSelector
	{
		private static readonly string[] StatementNames = {
			"expression_statement",
            "jump_statement",
		};

		public IEnumerable<XElement> Select(XElement root)
		{
			return root.Descendants()
				.Where(e => StatementNames.Contains(e.Name.LocalName))
				.Where(e => e.Parent.Name.LocalName == "statement");
		}
	}
}
