using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Utility;

namespace CoverageFramework.Operator.Selector
{
	// TODO: gp
	public class DistinctSelector : IXElementRangeSelector
	{
		private readonly IXElementRangeSelector _rangeSelector;

		public DistinctSelector(IXElementRangeSelector rangeSelector)
		{
			_rangeSelector = rangeSelector;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var eqcmp = new EqualityComparerWithFunc<IEnumerable<XElement>>(
				(b1_, b2_) => b1_.First() == b2_.First(),
				b_ => b_.First().GetHashCode());
			return _rangeSelector.Select(root).Distinct(eqcmp);
		}

		#endregion
	}
}