using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.Java
{
	public abstract class ControlFlowStatementSelectorForJava : IXElementRangeSelector
	{
		private readonly string _name;

		protected ControlFlowStatementSelectorForJava(string name)
		{
			_name = name;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var result = root
				.Elements()
				.SkipWhile(e_ => e_.Name.LocalName != _name)
				.Skip(1)
				.Take(1);
			if (!result.IsEmpty())
				yield return result;
		}

		#endregion
	}
}