﻿using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.Java
{
	public class SwitchCaseSelectorForJava : IXElementRangeSelector
	{
		#region IXElementRangeSelector メンバ

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var element = root.Element("ASwitchBlock");
			if (element == null)
				return new IEnumerable<XElement>[0];

			return element.Elements("ASwitchBlockStatementGroup")
				.SelectMany(e => e.Elements()
					.Where(e2 => e2.Name.LocalName.EndsWith("SwitchLabel")))
				.Select(e => e.ToEnumerable());
		}

		#endregion
	}
}