﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Java2
{
	[Export(typeof(IXElementSelector))]
	public class LackingBlockSelector : IXElementSelector
	{
		private static readonly string[] StatementNames = {
			"IfThenStatement",		// If
			"IfThenElseStatement",
			"IfThenElseStatementNoShortIf",
			"BasicForStatement",	// For
			"EnhancedForStatement",
			"ForStatementNoShortIf",
			"WhileStatement",		// While
			"WhileStatementNoShortIf",
			"DoStatement",			// Do - While
		};
		private static readonly string[] BlockNames = {
			"Statement",
			"StatementNoShortIf",
		};
		public IEnumerable<XElement> Select(XElement root)
		{
			return root.Descendants()
				.Where(e => StatementNames.Any(e.Name.LocalName.EndsWith))
				.SelectMany(e => e.Elements()
					.Where(e2 => BlockNames.Any(e.Name.LocalName.EndsWith)));
		}
	}
}
