using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector
{
	public abstract class ParenthesisSelector : IXElementRangeSelector
	{
		protected abstract bool IsLeftParenthesis(XElement e);
		protected abstract bool IsRightParenthesis(XElement e);

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var result = root.Elements()
				.SkipWhile(e2_ => !IsLeftParenthesis(e2_))
				.Skip(1)
				.TakeWhile(e2_ => !IsRightParenthesis(e2_));

			if (!result.IsEmpty())
				yield return result;
		}

		#endregion
	}
}