﻿using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

/*
 * PDG（プログラム依存グラフ）
 * 
 */

namespace CoverageFramework.Operator.Selector.Python
{
	public class ConditionalOperatorSelectorForPython : IXElementRangeSelector
	{
		private static readonly string[] _ifNames = new[] {
			"test",
		};

		#region IXElementRangeSelector メンバ

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			// 条件演算子 (exp1 if cond else exp2) <=> (cond ? exp1 : exp2)
			return _ifNames
				// 全てのif文要素を列挙
				.SelectMany(name_ => root.Descendants(name_))
				// if文の条件式に射影
				.Select(e_ => e_.Elements()
					.SkipWhile(e2_ => !(!e2_.HasElements && e2_.Value == "if"))
					.Skip(1)
					.TakeWhile(e2_ => !(!e2_.HasElements && e2_.Value == "else")))
				.Where(block_ => !block_.IsEmpty());
		}

		#endregion
	}
}