﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using Paraiba.Linq;
using Paraiba.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Python3
{
	[Export(typeof(IXElementSelector))]
	public class ConditionalTermSelector : AtomicConditionalTermSelector
	{
		private static readonly string[] TargetNames = {
			"or_test",
			"and_test",
		};

		private static readonly string[] WithoutParentNames = {
			"trailer",
		};

		protected override bool IsConditionalTerm(XElement element)
		{
			return TargetNames.Contains(element.Name.LocalName);
		}

		protected override bool IsAllowableParent(XElement element)
		{
			return !WithoutParentNames.Contains(element.Name.LocalName);
		}
	}
}
