using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector
{
	public class XElementRangeSelectorUnion : IXElementRangeSelector
	{
		private readonly IEnumerable<IXElementRangeSelector> _selectors;

		public XElementRangeSelectorUnion(IEnumerable<IXElementRangeSelector> selectors)
		{
			_selectors = selectors;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return _selectors.SelectMany(s => s.Select(root));
		}

		#endregion
	}
}