using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector
{
	// IXElementSelectořʂ̘aƂĂ܂Ƃ߂Selector
	public class XElementSelectorUnion : IXElementSelector
	{
		private readonly IEnumerable<IXElementSelector> _selectors;

		public XElementSelectorUnion(IEnumerable<IXElementSelector> selectors)
		{
			_selectors = selectors;
		}

		#region IXElementRangeSelector o

		public IEnumerable<XElement> Select(XElement root)
		{
			return _selectors.SelectMany(s => s.Select(root));
		}

		#endregion
	}
}